/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.util.regex.Pattern;
import reactor.core.publisher.Mono;

public class ScrubEtagPolicy
implements HttpPipelinePolicy {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final String ETAG = "eTag";

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return next.process().flatMap(response -> Mono.just((Object)this.scrubETagHeader((HttpResponse)response)));
    }

    private HttpResponse scrubETagHeader(HttpResponse unprocessedResponse) {
        HttpHeader eTagHeader = unprocessedResponse.getHeaders().get(ETAG);
        if (eTagHeader == null) {
            return unprocessedResponse;
        }
        unprocessedResponse.getHeaders().set(eTagHeader.getName(), QUOTE_PATTERN.matcher(eTagHeader.getValue()).replaceAll(""));
        return unprocessedResponse;
    }
}

