/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareClientBuilder;
import com.azure.storage.file.share.ShareDirectoryAsyncClient;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.SharePermission;
import com.azure.storage.file.share.implementation.models.SharesCreatePermissionHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotResponse;
import com.azure.storage.file.share.implementation.models.SharesGetAccessPolicyHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.SharesGetStatisticsResponse;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareInfo;
import com.azure.storage.file.share.models.ShareProperties;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareSnapshotInfo;
import com.azure.storage.file.share.models.ShareStatistics;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.options.ShareCreateOptions;
import com.azure.storage.file.share.options.ShareDeleteOptions;
import com.azure.storage.file.share.options.ShareGetAccessPolicyOptions;
import com.azure.storage.file.share.options.ShareGetPropertiesOptions;
import com.azure.storage.file.share.options.ShareGetStatisticsOptions;
import com.azure.storage.file.share.options.ShareSetAccessPolicyOptions;
import com.azure.storage.file.share.options.ShareSetMetadataOptions;
import com.azure.storage.file.share.options.ShareSetPropertiesOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ShareClientBuilder.class, isAsync=true)
public class ShareAsyncClient {
    private final ClientLogger logger = new ClientLogger(ShareAsyncClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;

    ShareAsyncClient(AzureFileStorageImpl client, String shareName, String snapshot, String accountName, ShareServiceVersion serviceVersion) {
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        this.shareName = shareName;
        this.snapshot = snapshot;
        this.accountName = accountName;
        this.azureFileStorageClient = client;
        this.serviceVersion = serviceVersion;
    }

    public String getAccountUrl() {
        return this.azureFileStorageClient.getUrl();
    }

    public String getShareUrl() {
        StringBuilder shareUrlString = new StringBuilder(this.azureFileStorageClient.getUrl()).append("/").append(this.shareName);
        if (this.snapshot != null) {
            shareUrlString.append("?sharesnapshot=").append(this.snapshot);
        }
        return shareUrlString.toString();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public ShareDirectoryAsyncClient getRootDirectoryClient() {
        return this.getDirectoryClient("");
    }

    public ShareDirectoryAsyncClient getDirectoryClient(String directoryName) {
        directoryName = "/".equals(directoryName) ? "" : directoryName;
        return new ShareDirectoryAsyncClient(this.azureFileStorageClient, this.shareName, directoryName, this.snapshot, this.accountName, this.serviceVersion);
    }

    public ShareFileAsyncClient getFileClient(String filePath) {
        return new ShareFileAsyncClient(this.azureFileStorageClient, this.shareName, filePath, this.snapshot, this.accountName, this.serviceVersion);
    }

    public ShareAsyncClient getSnapshotClient(String snapshot) {
        return new ShareAsyncClient(this.azureFileStorageClient, this.getShareName(), snapshot, this.getAccountName(), this.getServiceVersion());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> exists() {
        return this.existsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(context -> this.existsWithResponse((Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(new ShareGetPropertiesOptions(), context).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(t -> t instanceof ShareStorageException && ((ShareStorageException)((Object)((Object)t))).getStatusCode() == 404 && ((ShareStorageException)((Object)((Object)t))).getErrorCode() == ShareErrorCode.SHARE_NOT_FOUND, t -> {
            HttpResponse response = ((ShareStorageException)((Object)((Object)t))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareInfo> create() {
        try {
            return this.createWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareInfo>> createWithResponse(Map<String, String> metadata, Integer quotaInGB) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(new ShareCreateOptions().setMetadata(metadata).setQuotaInGb(quotaInGB), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareInfo>> createWithResponse(ShareCreateOptions options) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareInfo>> createWithResponse(ShareCreateOptions options, Context context) {
        context = context == null ? Context.NONE : context;
        options = options == null ? new ShareCreateOptions() : options;
        String enabledProtocol = options.getProtocols() == null ? null : options.getProtocols().toString();
        enabledProtocol = "".equals(enabledProtocol) ? null : enabledProtocol;
        return this.azureFileStorageClient.getShares().createWithResponseAsync(this.shareName, null, options.getMetadata(), options.getQuotaInGb(), options.getAccessTier(), enabledProtocol, options.getRootSquash(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapToShareInfoResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareSnapshotInfo> createSnapshot() {
        try {
            return this.createSnapshotWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareSnapshotInfo>> createSnapshotWithResponse(Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createSnapshotWithResponse(metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareSnapshotInfo>> createSnapshotWithResponse(Map<String, String> metadata, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getShares().createSnapshotWithResponseAsync(this.shareName, null, metadata, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapCreateSnapshotResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse() {
        try {
            return this.deleteWithResponse(new ShareDeleteOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(ShareDeleteOptions options) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(ShareDeleteOptions options, Context context) {
        options = options == null ? new ShareDeleteOptions() : options;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getShares().deleteWithResponseAsync(this.shareName, this.snapshot, null, ModelHelper.toDeleteSnapshotsOptionType(options.getDeleteSnapshotsOptions()), requestConditions.getLeaseId(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareProperties>> getPropertiesWithResponse() {
        try {
            return this.getPropertiesWithResponse(new ShareGetPropertiesOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareProperties>> getPropertiesWithResponse(ShareGetPropertiesOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getPropertiesWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareProperties>> getPropertiesWithResponse(ShareGetPropertiesOptions options, Context context) {
        options = options == null ? new ShareGetPropertiesOptions() : options;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getShares().getPropertiesWithResponseAsync(this.shareName, this.snapshot, null, requestConditions.getLeaseId(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapGetPropertiesResponse);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareInfo> setQuota(int quotaInGB) {
        try {
            return this.setQuotaWithResponse(quotaInGB).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareInfo>> setQuotaWithResponse(int quotaInGB) {
        try {
            return this.setPropertiesWithResponse(new ShareSetPropertiesOptions().setQuotaInGb(quotaInGB));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareInfo> setProperties(ShareSetPropertiesOptions options) {
        try {
            return this.setPropertiesWithResponse(options).map(Response::getValue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareInfo>> setPropertiesWithResponse(ShareSetPropertiesOptions options) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareInfo>> setPropertiesWithResponse(ShareSetPropertiesOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getShares().setPropertiesWithResponseAsync(this.shareName, null, options.getQuotaInGb(), options.getAccessTier(), requestConditions.getLeaseId(), options.getRootSquash(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapToShareInfoResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareInfo> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareInfo>> setMetadataWithResponse(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(new ShareSetMetadataOptions().setMetadata(metadata));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareInfo>> setMetadataWithResponse(ShareSetMetadataOptions options) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareInfo>> setMetadataWithResponse(ShareSetMetadataOptions options, Context context) {
        options = options == null ? new ShareSetMetadataOptions() : options;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getShares().setMetadataWithResponseAsync(this.shareName, null, options.getMetadata(), requestConditions.getLeaseId(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapToShareInfoResponse);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareSignedIdentifier> getAccessPolicy() {
        try {
            return this.getAccessPolicy(new ShareGetAccessPolicyOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareSignedIdentifier> getAccessPolicy(ShareGetAccessPolicyOptions options) {
        ShareGetAccessPolicyOptions finalOptions = options == null ? new ShareGetAccessPolicyOptions() : options;
        ShareRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new ShareRequestConditions() : finalOptions.getRequestConditions();
        try {
            Function<String, Mono> retriever = marker -> this.azureFileStorageClient.getShares().getAccessPolicyWithResponseAsync(this.shareName, null, requestConditions.getLeaseId(), Context.NONE).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), null, (Object)((SharesGetAccessPolicyHeaders)response.getDeserializedHeaders())));
            return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareInfo> setAccessPolicy(List<ShareSignedIdentifier> permissions) {
        try {
            return this.setAccessPolicyWithResponse(permissions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareInfo>> setAccessPolicyWithResponse(List<ShareSignedIdentifier> permissions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessPolicyWithResponse(new ShareSetAccessPolicyOptions().setPermissions(permissions), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareInfo>> setAccessPolicyWithResponse(ShareSetAccessPolicyOptions options) {
        try {
            return FluxUtil.withContext(context -> this.setAccessPolicyWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareInfo>> setAccessPolicyWithResponse(ShareSetAccessPolicyOptions options, Context context) {
        options = options == null ? new ShareSetAccessPolicyOptions() : options;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        List<ShareSignedIdentifier> permissions = options.getPermissions();
        if (permissions != null) {
            for (ShareSignedIdentifier permission : permissions) {
                if (permission.getAccessPolicy() != null && permission.getAccessPolicy().getStartsOn() != null) {
                    permission.getAccessPolicy().setStartsOn(permission.getAccessPolicy().getStartsOn().truncatedTo(ChronoUnit.SECONDS));
                }
                if (permission.getAccessPolicy() == null || permission.getAccessPolicy().getExpiresOn() == null) continue;
                permission.getAccessPolicy().setExpiresOn(permission.getAccessPolicy().getExpiresOn().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getShares().setAccessPolicyWithResponseAsync(this.shareName, null, requestConditions.getLeaseId(), permissions, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapToShareInfoResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareStatistics> getStatistics() {
        try {
            return this.getStatisticsWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareStatistics>> getStatisticsWithResponse() {
        try {
            return this.getStatisticsWithResponse(new ShareGetStatisticsOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareStatistics>> getStatisticsWithResponse(ShareGetStatisticsOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getStatisticsWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareStatistics>> getStatisticsWithResponse(ShareGetStatisticsOptions options, Context context) {
        options = options == null ? new ShareGetStatisticsOptions() : options;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getShares().getStatisticsWithResponseAsync(this.shareName, null, requestConditions.getLeaseId(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapGetStatisticsResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareDirectoryAsyncClient> createDirectory(String directoryName) {
        try {
            return this.createDirectoryWithResponse(directoryName, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareDirectoryAsyncClient>> createDirectoryWithResponse(String directoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createDirectoryWithResponse(directoryName, smbProperties, filePermission, metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryAsyncClient>> createDirectoryWithResponse(String directoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Context context) {
        ShareDirectoryAsyncClient shareDirectoryAsyncClient = this.getDirectoryClient(directoryName);
        return shareDirectoryAsyncClient.createWithResponse(smbProperties, filePermission, metadata).map(response -> new SimpleResponse(response, (Object)shareDirectoryAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileAsyncClient> createFile(String fileName, long maxSize) {
        try {
            return this.createFileWithResponse(fileName, maxSize, null, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        return this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Context context) {
        ShareFileAsyncClient shareFileAsyncClient = this.getFileClient(fileName);
        return shareFileAsyncClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, context).map(response -> new SimpleResponse(response, (Object)shareFileAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDirectory(String directoryName) {
        try {
            return this.deleteDirectoryWithResponse(directoryName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDirectoryWithResponse(String directoryName) {
        try {
            return FluxUtil.withContext(context -> this.deleteDirectoryWithResponse(directoryName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteDirectoryWithResponse(String directoryName, Context context) {
        return this.getDirectoryClient(directoryName).deleteWithResponse(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFile(String fileName) {
        try {
            return this.deleteFileWithResponse(fileName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFileWithResponse(String fileName) {
        return this.deleteFileWithResponse(fileName, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteFileWithResponse(fileName, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> createPermission(String filePermission) {
        try {
            return this.createPermissionWithResponse(filePermission).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> createPermissionWithResponse(String filePermission) {
        try {
            return FluxUtil.withContext(context -> this.createPermissionWithResponse(filePermission, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> createPermissionWithResponse(String filePermission, Context context) {
        SharePermission sharePermission = new SharePermission().setPermission(filePermission);
        return this.azureFileStorageClient.getShares().createPermissionWithResponseAsync(this.shareName, sharePermission, null, context).map(response -> new SimpleResponse((Response)response, (Object)((SharesCreatePermissionHeaders)response.getDeserializedHeaders()).getXMsFilePermissionKey()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getPermission(String filePermissionKey) {
        try {
            return this.getPermissionWithResponse(filePermissionKey).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> getPermissionWithResponse(String filePermissionKey) {
        try {
            return FluxUtil.withContext(context -> this.getPermissionWithResponse(filePermissionKey, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> getPermissionWithResponse(String filePermissionKey, Context context) {
        return this.azureFileStorageClient.getShares().getPermissionWithResponseAsync(this.shareName, filePermissionKey, null, context).map(response -> new SimpleResponse((Response)response, (Object)response.getValue().getPermission()));
    }

    public String getSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.generateSas(shareServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }

    private Response<ShareInfo> mapToShareInfoResponse(Response<?> response) {
        String eTag = response.getHeaders().getValue("ETag");
        OffsetDateTime lastModified = new DateTimeRfc1123(response.getHeaders().getValue("Last-Modified")).getDateTime();
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new ShareInfo(eTag, lastModified));
    }

    private Response<ShareSnapshotInfo> mapCreateSnapshotResponse(SharesCreateSnapshotResponse response) {
        SharesCreateSnapshotHeaders headers = (SharesCreateSnapshotHeaders)response.getDeserializedHeaders();
        ShareSnapshotInfo snapshotInfo = new ShareSnapshotInfo(headers.getXMsSnapshot(), headers.getETag(), headers.getLastModified());
        return new SimpleResponse((Response)response, (Object)snapshotInfo);
    }

    private Response<ShareProperties> mapGetPropertiesResponse(SharesGetPropertiesResponse response) {
        SharesGetPropertiesHeaders headers = (SharesGetPropertiesHeaders)response.getDeserializedHeaders();
        ShareProperties shareProperties = new ShareProperties().setETag(headers.getETag()).setLastModified(headers.getLastModified()).setMetadata(headers.getXMsMeta()).setQuota(headers.getXMsShareQuota()).setNextAllowedQuotaDowngradeTime(headers.getXMsShareNextAllowedQuotaDowngradeTime()).setProvisionedEgressMBps(headers.getXMsShareProvisionedEgressMbps()).setProvisionedIngressMBps(headers.getXMsShareProvisionedIngressMbps()).setProvisionedBandwidthMiBps(headers.getXMsShareProvisionedBandwidthMibps()).setProvisionedIops(headers.getXMsShareProvisionedIops()).setLeaseDuration(headers.getXMsLeaseDuration()).setLeaseState(headers.getXMsLeaseState()).setLeaseStatus(headers.getXMsLeaseStatus()).setAccessTier(headers.getXMsAccessTier()).setAccessTierChangeTime(headers.getXMsAccessTierChangeTime()).setAccessTierTransitionState(headers.getXMsAccessTierTransitionState()).setProtocols(ModelHelper.parseShareProtocols(headers.getXMsEnabledProtocols())).setRootSquash(headers.getXMsRootSquash());
        return new SimpleResponse((Response)response, (Object)shareProperties);
    }

    private Response<ShareStatistics> mapGetStatisticsResponse(SharesGetStatisticsResponse response) {
        ShareStatistics shareStatistics = new ShareStatistics(response.getValue().getShareUsageBytes());
        return new SimpleResponse((Response)response, (Object)shareStatistics);
    }
}

