/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.models.BuilderProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BuilderProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private BuilderProvisioningState provisioningState;
    @JsonProperty(value="environmentId", required=true)
    private String environmentId;
    @JsonProperty(value="containerRegistries")
    private List<ContainerRegistry> containerRegistries;
    private static final ClientLogger LOGGER = new ClientLogger(BuilderProperties.class);

    public BuilderProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public BuilderProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public List<ContainerRegistry> containerRegistries() {
        return this.containerRegistries;
    }

    public BuilderProperties withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        this.containerRegistries = containerRegistries;
        return this;
    }

    public void validate() {
        if (this.environmentId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property environmentId in model BuilderProperties"));
        }
        if (this.containerRegistries() != null) {
            this.containerRegistries().forEach(e -> e.validate());
        }
    }
}

