/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentProperties;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ConnectedEnvironmentInner
extends Resource {
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="properties")
    private ConnectedEnvironmentProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public ConnectedEnvironmentInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private ConnectedEnvironmentProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public ConnectedEnvironmentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ConnectedEnvironmentInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ConnectedEnvironmentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String deploymentErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentErrors();
    }

    public String defaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDomain();
    }

    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    public ConnectedEnvironmentInner withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedEnvironmentProperties();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    public String daprAIConnectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().daprAIConnectionString();
    }

    public ConnectedEnvironmentInner withDaprAIConnectionString(String daprAIConnectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedEnvironmentProperties();
        }
        this.innerProperties().withDaprAIConnectionString(daprAIConnectionString);
        return this;
    }

    public CustomDomainConfiguration customDomainConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomainConfiguration();
    }

    public ConnectedEnvironmentInner withCustomDomainConfiguration(CustomDomainConfiguration customDomainConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedEnvironmentProperties();
        }
        this.innerProperties().withCustomDomainConfiguration(customDomainConfiguration);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

