/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.resourcemanager.appcontainers.models.AppInsightsConfiguration;
import com.azure.resourcemanager.appcontainers.models.AppLogsConfiguration;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.DaprConfiguration;
import com.azure.resourcemanager.appcontainers.models.EnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.KedaConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerAuthentication;
import com.azure.resourcemanager.appcontainers.models.OpenTelemetryConfiguration;
import com.azure.resourcemanager.appcontainers.models.VnetConfiguration;
import com.azure.resourcemanager.appcontainers.models.WorkloadProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ManagedEnvironmentProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private EnvironmentProvisioningState provisioningState;
    @JsonProperty(value="daprAIInstrumentationKey")
    private String daprAIInstrumentationKey;
    @JsonProperty(value="daprAIConnectionString")
    private String daprAIConnectionString;
    @JsonProperty(value="vnetConfiguration")
    private VnetConfiguration vnetConfiguration;
    @JsonProperty(value="deploymentErrors", access=JsonProperty.Access.WRITE_ONLY)
    private String deploymentErrors;
    @JsonProperty(value="defaultDomain", access=JsonProperty.Access.WRITE_ONLY)
    private String defaultDomain;
    @JsonProperty(value="staticIp", access=JsonProperty.Access.WRITE_ONLY)
    private String staticIp;
    @JsonProperty(value="appLogsConfiguration")
    private AppLogsConfiguration appLogsConfiguration;
    @JsonProperty(value="appInsightsConfiguration")
    private AppInsightsConfiguration appInsightsConfiguration;
    @JsonProperty(value="openTelemetryConfiguration")
    private OpenTelemetryConfiguration openTelemetryConfiguration;
    @JsonProperty(value="zoneRedundant")
    private Boolean zoneRedundant;
    @JsonProperty(value="customDomainConfiguration")
    private CustomDomainConfiguration customDomainConfiguration;
    @JsonProperty(value="eventStreamEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String eventStreamEndpoint;
    @JsonProperty(value="workloadProfiles")
    private List<WorkloadProfile> workloadProfiles;
    @JsonProperty(value="kedaConfiguration")
    private KedaConfiguration kedaConfiguration;
    @JsonProperty(value="daprConfiguration")
    private DaprConfiguration daprConfiguration;
    @JsonProperty(value="infrastructureResourceGroup")
    private String infrastructureResourceGroup;
    @JsonProperty(value="peerAuthentication")
    private ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication;

    public EnvironmentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String daprAIInstrumentationKey() {
        return this.daprAIInstrumentationKey;
    }

    public ManagedEnvironmentProperties withDaprAIInstrumentationKey(String daprAIInstrumentationKey) {
        this.daprAIInstrumentationKey = daprAIInstrumentationKey;
        return this;
    }

    public String daprAIConnectionString() {
        return this.daprAIConnectionString;
    }

    public ManagedEnvironmentProperties withDaprAIConnectionString(String daprAIConnectionString) {
        this.daprAIConnectionString = daprAIConnectionString;
        return this;
    }

    public VnetConfiguration vnetConfiguration() {
        return this.vnetConfiguration;
    }

    public ManagedEnvironmentProperties withVnetConfiguration(VnetConfiguration vnetConfiguration) {
        this.vnetConfiguration = vnetConfiguration;
        return this;
    }

    public String deploymentErrors() {
        return this.deploymentErrors;
    }

    public String defaultDomain() {
        return this.defaultDomain;
    }

    public String staticIp() {
        return this.staticIp;
    }

    public AppLogsConfiguration appLogsConfiguration() {
        return this.appLogsConfiguration;
    }

    public ManagedEnvironmentProperties withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        this.appLogsConfiguration = appLogsConfiguration;
        return this;
    }

    public AppInsightsConfiguration appInsightsConfiguration() {
        return this.appInsightsConfiguration;
    }

    public ManagedEnvironmentProperties withAppInsightsConfiguration(AppInsightsConfiguration appInsightsConfiguration) {
        this.appInsightsConfiguration = appInsightsConfiguration;
        return this;
    }

    public OpenTelemetryConfiguration openTelemetryConfiguration() {
        return this.openTelemetryConfiguration;
    }

    public ManagedEnvironmentProperties withOpenTelemetryConfiguration(OpenTelemetryConfiguration openTelemetryConfiguration) {
        this.openTelemetryConfiguration = openTelemetryConfiguration;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ManagedEnvironmentProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public CustomDomainConfiguration customDomainConfiguration() {
        return this.customDomainConfiguration;
    }

    public ManagedEnvironmentProperties withCustomDomainConfiguration(CustomDomainConfiguration customDomainConfiguration) {
        this.customDomainConfiguration = customDomainConfiguration;
        return this;
    }

    public String eventStreamEndpoint() {
        return this.eventStreamEndpoint;
    }

    public List<WorkloadProfile> workloadProfiles() {
        return this.workloadProfiles;
    }

    public ManagedEnvironmentProperties withWorkloadProfiles(List<WorkloadProfile> workloadProfiles) {
        this.workloadProfiles = workloadProfiles;
        return this;
    }

    public KedaConfiguration kedaConfiguration() {
        return this.kedaConfiguration;
    }

    public ManagedEnvironmentProperties withKedaConfiguration(KedaConfiguration kedaConfiguration) {
        this.kedaConfiguration = kedaConfiguration;
        return this;
    }

    public DaprConfiguration daprConfiguration() {
        return this.daprConfiguration;
    }

    public ManagedEnvironmentProperties withDaprConfiguration(DaprConfiguration daprConfiguration) {
        this.daprConfiguration = daprConfiguration;
        return this;
    }

    public String infrastructureResourceGroup() {
        return this.infrastructureResourceGroup;
    }

    public ManagedEnvironmentProperties withInfrastructureResourceGroup(String infrastructureResourceGroup) {
        this.infrastructureResourceGroup = infrastructureResourceGroup;
        return this;
    }

    public ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication() {
        return this.peerAuthentication;
    }

    public ManagedEnvironmentProperties withPeerAuthentication(ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication) {
        this.peerAuthentication = peerAuthentication;
        return this;
    }

    public void validate() {
        if (this.vnetConfiguration() != null) {
            this.vnetConfiguration().validate();
        }
        if (this.appLogsConfiguration() != null) {
            this.appLogsConfiguration().validate();
        }
        if (this.appInsightsConfiguration() != null) {
            this.appInsightsConfiguration().validate();
        }
        if (this.openTelemetryConfiguration() != null) {
            this.openTelemetryConfiguration().validate();
        }
        if (this.customDomainConfiguration() != null) {
            this.customDomainConfiguration().validate();
        }
        if (this.workloadProfiles() != null) {
            this.workloadProfiles().forEach(e -> e.validate());
        }
        if (this.kedaConfiguration() != null) {
            this.kedaConfiguration().validate();
        }
        if (this.daprConfiguration() != null) {
            this.daprConfiguration().validate();
        }
        if (this.peerAuthentication() != null) {
            this.peerAuthentication().validate();
        }
    }
}

