/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsDaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DaprComponentsCollection;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

public final class ConnectedEnvironmentsDaprComponentsClientImpl
implements ConnectedEnvironmentsDaprComponentsClient {
    private final ConnectedEnvironmentsDaprComponentsService service;
    private final ContainerAppsApiClientImpl client;

    ConnectedEnvironmentsDaprComponentsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (ConnectedEnvironmentsDaprComponentsService)RestProxy.create(ConnectedEnvironmentsDaprComponentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DaprComponentInner>> listSinglePageAsync(String resourceGroupName, String connectedEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DaprComponentsCollection)res.getValue()).value(), ((DaprComponentsCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DaprComponentInner>> listSinglePageAsync(String resourceGroupName, String connectedEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DaprComponentsCollection)res.getValue()).value(), ((DaprComponentsCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DaprComponentInner> listAsync(String resourceGroupName, String connectedEnvironmentName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, connectedEnvironmentName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DaprComponentInner> listAsync(String resourceGroupName, String connectedEnvironmentName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, connectedEnvironmentName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DaprComponentInner> list(String resourceGroupName, String connectedEnvironmentName) {
        return new PagedIterable(this.listAsync(resourceGroupName, connectedEnvironmentName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DaprComponentInner> list(String resourceGroupName, String connectedEnvironmentName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, connectedEnvironmentName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DaprComponentInner>> getWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DaprComponentInner>> getWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DaprComponentInner> getAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return this.getWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DaprComponentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DaprComponentInner> getWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DaprComponentInner get(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return (DaprComponentInner)((Object)this.getWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DaprComponentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName, DaprComponentInner daprComponentEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        if (daprComponentEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter daprComponentEnvelope is required and cannot be null."));
        }
        daprComponentEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), daprComponentEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DaprComponentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName, DaprComponentInner daprComponentEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        if (daprComponentEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter daprComponentEnvelope is required and cannot be null."));
        }
        daprComponentEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), daprComponentEnvelope, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DaprComponentInner> createOrUpdateAsync(String resourceGroupName, String connectedEnvironmentName, String componentName, DaprComponentInner daprComponentEnvelope) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName, daprComponentEnvelope).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DaprComponentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DaprComponentInner> createOrUpdateWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, DaprComponentInner daprComponentEnvelope, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName, daprComponentEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DaprComponentInner createOrUpdate(String resourceGroupName, String connectedEnvironmentName, String componentName, DaprComponentInner daprComponentEnvelope) {
        return (DaprComponentInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, componentName, daprComponentEnvelope, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return this.deleteWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DaprSecretsCollectionInner>> listSecretsWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSecrets(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DaprSecretsCollectionInner>> listSecretsWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (componentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSecrets(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, componentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DaprSecretsCollectionInner> listSecretsAsync(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return this.listSecretsWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName).flatMap(res -> Mono.justOrEmpty((Object)((DaprSecretsCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DaprSecretsCollectionInner> listSecretsWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        return (Response)this.listSecretsWithResponseAsync(resourceGroupName, connectedEnvironmentName, componentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DaprSecretsCollectionInner listSecrets(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        return (DaprSecretsCollectionInner)this.listSecretsWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DaprComponentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DaprComponentsCollection)res.getValue()).value(), ((DaprComponentsCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DaprComponentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DaprComponentsCollection)res.getValue()).value(), ((DaprComponentsCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClie")
    public static interface ConnectedEnvironmentsDaprComponentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DaprComponentsCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DaprComponentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DaprComponentInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DaprComponentInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}/listSecrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DaprSecretsCollectionInner>> listSecrets(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="componentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DaprComponentsCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

