/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.DotNetComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DotNetComponentInner;
import com.azure.resourcemanager.appcontainers.implementation.DotNetComponentImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.DotNetComponent;
import com.azure.resourcemanager.appcontainers.models.DotNetComponents;

public final class DotNetComponentsImpl
implements DotNetComponents {
    private static final ClientLogger LOGGER = new ClientLogger(DotNetComponentsImpl.class);
    private final DotNetComponentsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public DotNetComponentsImpl(DotNetComponentsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DotNetComponent> list(String resourceGroupName, String environmentName) {
        PagedIterable<DotNetComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DotNetComponentImpl((DotNetComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DotNetComponent> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<DotNetComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DotNetComponentImpl((DotNetComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DotNetComponent> getWithResponse(String resourceGroupName, String environmentName, String name, Context context) {
        Response<DotNetComponentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DotNetComponentImpl((DotNetComponentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DotNetComponent get(String resourceGroupName, String environmentName, String name) {
        DotNetComponentInner inner = this.serviceClient().get(resourceGroupName, environmentName, name);
        if (inner != null) {
            return new DotNetComponentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String name) {
        this.serviceClient().delete(resourceGroupName, environmentName, name);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String name, Context context) {
        this.serviceClient().delete(resourceGroupName, environmentName, name, context);
    }

    @Override
    public DotNetComponent getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "dotNetComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dotNetComponents'.", id)));
        }
        return (DotNetComponent)this.getWithResponse(resourceGroupName, environmentName, name, Context.NONE).getValue();
    }

    @Override
    public Response<DotNetComponent> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "dotNetComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dotNetComponents'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, name, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "dotNetComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dotNetComponents'.", id)));
        }
        this.delete(resourceGroupName, environmentName, name, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "dotNetComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dotNetComponents'.", id)));
        }
        this.delete(resourceGroupName, environmentName, name, context);
    }

    private DotNetComponentsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public DotNetComponentImpl define(String name) {
        return new DotNetComponentImpl(name, this.manager());
    }
}

