/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.appcontainers.fluent.models.JobExecutionInner;
import com.azure.resourcemanager.appcontainers.implementation.JobExecutionImpl;
import com.azure.resourcemanager.appcontainers.models.JobExecution;
import com.azure.resourcemanager.appcontainers.models.ResourceProviders;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<JobExecution> jobExecutionWithResponse(String resourceGroupName, String jobName, String jobExecutionName, Context context) {
        Response<JobExecutionInner> inner = this.serviceClient().jobExecutionWithResponse(resourceGroupName, jobName, jobExecutionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobExecutionImpl((JobExecutionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public JobExecution jobExecution(String resourceGroupName, String jobName, String jobExecutionName) {
        JobExecutionInner inner = this.serviceClient().jobExecution(resourceGroupName, jobName, jobExecutionName);
        if (inner != null) {
            return new JobExecutionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<String> getCustomDomainVerificationIdWithResponse(Context context) {
        return this.serviceClient().getCustomDomainVerificationIdWithResponse(context);
    }

    @Override
    public String getCustomDomainVerificationId() {
        return this.serviceClient().getCustomDomainVerificationId();
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

