/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.UsagesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.UsageInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.implementation.UsageImpl;
import com.azure.resourcemanager.appcontainers.models.Usage;
import com.azure.resourcemanager.appcontainers.models.Usages;

public final class UsagesImpl
implements Usages {
    private static final ClientLogger LOGGER = new ClientLogger(UsagesImpl.class);
    private final UsagesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public UsagesImpl(UsagesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Usage> list(String location) {
        PagedIterable<UsageInner> inner = this.serviceClient().list(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageImpl((UsageInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Usage> list(String location, Context context) {
        PagedIterable<UsageInner> inner = this.serviceClient().list(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageImpl((UsageInner)inner1, this.manager()));
    }

    private UsagesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

