/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyInner;
import com.azure.resourcemanager.appcontainers.models.CircuitBreakerPolicy;
import com.azure.resourcemanager.appcontainers.models.HttpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.HttpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TcpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.TcpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TimeoutPolicy;

public interface AppResiliency {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public TimeoutPolicy timeoutPolicy();

    public HttpRetryPolicy httpRetryPolicy();

    public TcpRetryPolicy tcpRetryPolicy();

    public CircuitBreakerPolicy circuitBreakerPolicy();

    public HttpConnectionPool httpConnectionPool();

    public TcpConnectionPool tcpConnectionPool();

    public String resourceGroupName();

    public AppResiliencyInner innerModel();

    public Update update();

    public AppResiliency refresh();

    public AppResiliency refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithTcpConnectionPool {
            public Update withTcpConnectionPool(TcpConnectionPool var1);
        }

        public static interface WithHttpConnectionPool {
            public Update withHttpConnectionPool(HttpConnectionPool var1);
        }

        public static interface WithCircuitBreakerPolicy {
            public Update withCircuitBreakerPolicy(CircuitBreakerPolicy var1);
        }

        public static interface WithTcpRetryPolicy {
            public Update withTcpRetryPolicy(TcpRetryPolicy var1);
        }

        public static interface WithHttpRetryPolicy {
            public Update withHttpRetryPolicy(HttpRetryPolicy var1);
        }

        public static interface WithTimeoutPolicy {
            public Update withTimeoutPolicy(TimeoutPolicy var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTimeoutPolicy,
    UpdateStages.WithHttpRetryPolicy,
    UpdateStages.WithTcpRetryPolicy,
    UpdateStages.WithCircuitBreakerPolicy,
    UpdateStages.WithHttpConnectionPool,
    UpdateStages.WithTcpConnectionPool {
        public AppResiliency apply();

        public AppResiliency apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithTcpConnectionPool {
            public WithCreate withTcpConnectionPool(TcpConnectionPool var1);
        }

        public static interface WithHttpConnectionPool {
            public WithCreate withHttpConnectionPool(HttpConnectionPool var1);
        }

        public static interface WithCircuitBreakerPolicy {
            public WithCreate withCircuitBreakerPolicy(CircuitBreakerPolicy var1);
        }

        public static interface WithTcpRetryPolicy {
            public WithCreate withTcpRetryPolicy(TcpRetryPolicy var1);
        }

        public static interface WithHttpRetryPolicy {
            public WithCreate withHttpRetryPolicy(HttpRetryPolicy var1);
        }

        public static interface WithTimeoutPolicy {
            public WithCreate withTimeoutPolicy(TimeoutPolicy var1);
        }

        public static interface WithCreate
        extends WithTimeoutPolicy,
        WithHttpRetryPolicy,
        WithTcpRetryPolicy,
        WithCircuitBreakerPolicy,
        WithHttpConnectionPool,
        WithTcpConnectionPool {
            public AppResiliency create();

            public AppResiliency create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingContainerApp(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

