/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderResourceInner;
import com.azure.resourcemanager.appcontainers.models.BuilderProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistry;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.util.List;
import java.util.Map;

public interface BuilderResource {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public BuilderProvisioningState provisioningState();

    public String environmentId();

    public List<ContainerRegistry> containerRegistries();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public BuilderResourceInner innerModel();

    public Update update();

    public BuilderResource refresh();

    public BuilderResource refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithEnvironmentId {
            public Update withEnvironmentId(String var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithEnvironmentId {
        public BuilderResource apply();

        public BuilderResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithContainerRegistries {
            public WithCreate withContainerRegistries(List<ContainerRegistry> var1);
        }

        public static interface WithEnvironmentId {
            public WithCreate withEnvironmentId(String var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithEnvironmentId,
        WithContainerRegistries {
            public BuilderResource create();

            public BuilderResource create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

