/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.resourcemanager.appcontainers.models.BaseContainer;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProbe;
import com.azure.resourcemanager.appcontainers.models.ContainerResources;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVar;
import com.azure.resourcemanager.appcontainers.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Container
extends BaseContainer {
    @JsonProperty(value="probes")
    private List<ContainerAppProbe> probes;

    public List<ContainerAppProbe> probes() {
        return this.probes;
    }

    public Container withProbes(List<ContainerAppProbe> probes) {
        this.probes = probes;
        return this;
    }

    @Override
    public Container withImage(String image) {
        super.withImage(image);
        return this;
    }

    @Override
    public Container withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public Container withCommand(List<String> command) {
        super.withCommand(command);
        return this;
    }

    @Override
    public Container withArgs(List<String> args) {
        super.withArgs(args);
        return this;
    }

    @Override
    public Container withEnv(List<EnvironmentVar> env) {
        super.withEnv(env);
        return this;
    }

    @Override
    public Container withResources(ContainerResources resources) {
        super.withResources(resources);
        return this;
    }

    @Override
    public Container withVolumeMounts(List<VolumeMount> volumeMounts) {
        super.withVolumeMounts(volumeMounts);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.probes() != null) {
            this.probes().forEach(e -> e.validate());
        }
    }
}

