/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.JavaComponentInner;
import com.azure.resourcemanager.appcontainers.models.JavaComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.JavaComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JavaComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.JavaComponentType;
import java.util.List;

public interface JavaComponent {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public JavaComponentType componentType();

    public JavaComponentProvisioningState provisioningState();

    public List<JavaComponentConfigurationProperty> configurations();

    public List<JavaComponentServiceBind> serviceBinds();

    public String resourceGroupName();

    public JavaComponentInner innerModel();

    public Update update();

    public JavaComponent refresh();

    public JavaComponent refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithServiceBinds {
            public Update withServiceBinds(List<JavaComponentServiceBind> var1);
        }

        public static interface WithConfigurations {
            public Update withConfigurations(List<JavaComponentConfigurationProperty> var1);
        }

        public static interface WithComponentType {
            public Update withComponentType(JavaComponentType var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithComponentType,
    UpdateStages.WithConfigurations,
    UpdateStages.WithServiceBinds {
        public JavaComponent apply();

        public JavaComponent apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithServiceBinds {
            public WithCreate withServiceBinds(List<JavaComponentServiceBind> var1);
        }

        public static interface WithConfigurations {
            public WithCreate withConfigurations(List<JavaComponentConfigurationProperty> var1);
        }

        public static interface WithComponentType {
            public WithCreate withComponentType(JavaComponentType var1);
        }

        public static interface WithCreate
        extends WithComponentType,
        WithConfigurations,
        WithServiceBinds {
            public JavaComponent create();

            public JavaComponent create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingManagedEnvironment(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

