/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.models.JobConfigurationEventTriggerConfig;
import com.azure.resourcemanager.appcontainers.models.JobConfigurationManualTriggerConfig;
import com.azure.resourcemanager.appcontainers.models.JobConfigurationScheduleTriggerConfig;
import com.azure.resourcemanager.appcontainers.models.RegistryCredentials;
import com.azure.resourcemanager.appcontainers.models.Secret;
import com.azure.resourcemanager.appcontainers.models.TriggerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class JobConfiguration {
    @JsonProperty(value="secrets")
    private List<Secret> secrets;
    @JsonProperty(value="triggerType", required=true)
    private TriggerType triggerType;
    @JsonProperty(value="replicaTimeout", required=true)
    private int replicaTimeout;
    @JsonProperty(value="replicaRetryLimit")
    private Integer replicaRetryLimit;
    @JsonProperty(value="manualTriggerConfig")
    private JobConfigurationManualTriggerConfig manualTriggerConfig;
    @JsonProperty(value="scheduleTriggerConfig")
    private JobConfigurationScheduleTriggerConfig scheduleTriggerConfig;
    @JsonProperty(value="eventTriggerConfig")
    private JobConfigurationEventTriggerConfig eventTriggerConfig;
    @JsonProperty(value="registries")
    private List<RegistryCredentials> registries;
    private static final ClientLogger LOGGER = new ClientLogger(JobConfiguration.class);

    public List<Secret> secrets() {
        return this.secrets;
    }

    public JobConfiguration withSecrets(List<Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public TriggerType triggerType() {
        return this.triggerType;
    }

    public JobConfiguration withTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    public int replicaTimeout() {
        return this.replicaTimeout;
    }

    public JobConfiguration withReplicaTimeout(int replicaTimeout) {
        this.replicaTimeout = replicaTimeout;
        return this;
    }

    public Integer replicaRetryLimit() {
        return this.replicaRetryLimit;
    }

    public JobConfiguration withReplicaRetryLimit(Integer replicaRetryLimit) {
        this.replicaRetryLimit = replicaRetryLimit;
        return this;
    }

    public JobConfigurationManualTriggerConfig manualTriggerConfig() {
        return this.manualTriggerConfig;
    }

    public JobConfiguration withManualTriggerConfig(JobConfigurationManualTriggerConfig manualTriggerConfig) {
        this.manualTriggerConfig = manualTriggerConfig;
        return this;
    }

    public JobConfigurationScheduleTriggerConfig scheduleTriggerConfig() {
        return this.scheduleTriggerConfig;
    }

    public JobConfiguration withScheduleTriggerConfig(JobConfigurationScheduleTriggerConfig scheduleTriggerConfig) {
        this.scheduleTriggerConfig = scheduleTriggerConfig;
        return this;
    }

    public JobConfigurationEventTriggerConfig eventTriggerConfig() {
        return this.eventTriggerConfig;
    }

    public JobConfiguration withEventTriggerConfig(JobConfigurationEventTriggerConfig eventTriggerConfig) {
        this.eventTriggerConfig = eventTriggerConfig;
        return this;
    }

    public List<RegistryCredentials> registries() {
        return this.registries;
    }

    public JobConfiguration withRegistries(List<RegistryCredentials> registries) {
        this.registries = registries;
        return this;
    }

    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
        if (this.triggerType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property triggerType in model JobConfiguration"));
        }
        if (this.manualTriggerConfig() != null) {
            this.manualTriggerConfig().validate();
        }
        if (this.scheduleTriggerConfig() != null) {
            this.scheduleTriggerConfig().validate();
        }
        if (this.eventTriggerConfig() != null) {
            this.eventTriggerConfig().validate();
        }
        if (this.registries() != null) {
            this.registries().forEach(e -> e.validate());
        }
    }
}

