/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.CheckNameResourceTypes;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ResourceNameAvailabilityRequest {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="type", required=true)
    private CheckNameResourceTypes type;
    @JsonProperty(value="isFqdn")
    private Boolean isFqdn;
    @JsonProperty(value="environmentId")
    private String environmentId;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceNameAvailabilityRequest.class);

    public String name() {
        return this.name;
    }

    public ResourceNameAvailabilityRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CheckNameResourceTypes type() {
        return this.type;
    }

    public ResourceNameAvailabilityRequest withType(CheckNameResourceTypes type) {
        this.type = type;
        return this;
    }

    public Boolean isFqdn() {
        return this.isFqdn;
    }

    public ResourceNameAvailabilityRequest withIsFqdn(Boolean isFqdn) {
        this.isFqdn = isFqdn;
        return this;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public ResourceNameAvailabilityRequest withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model ResourceNameAvailabilityRequest"));
        }
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model ResourceNameAvailabilityRequest"));
        }
    }
}

