/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.fluent.models.DeploymentExtensionSpecProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class DeploymentExtensionSpec {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties")
    private DeploymentExtensionSpecProperties innerProperties;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentExtensionSpec.class);

    public String name() {
        return this.name;
    }

    public DeploymentExtensionSpec withName(String name) {
        this.name = name;
        return this;
    }

    private DeploymentExtensionSpecProperties innerProperties() {
        return this.innerProperties;
    }

    public String extensionType() {
        return this.innerProperties() == null ? null : this.innerProperties().extensionType();
    }

    public DeploymentExtensionSpec withExtensionType(String extensionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentExtensionSpecProperties();
        }
        this.innerProperties().withExtensionType(extensionType);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public DeploymentExtensionSpec withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentExtensionSpecProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public Object settings() {
        return this.innerProperties() == null ? null : this.innerProperties().settings();
    }

    public DeploymentExtensionSpec withSettings(Object settings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentExtensionSpecProperties();
        }
        this.innerProperties().withSettings(settings);
        return this;
    }

    public Object protectedSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().protectedSettings();
    }

    public DeploymentExtensionSpec withProtectedSettings(Object protectedSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentExtensionSpecProperties();
        }
        this.innerProperties().withProtectedSettings(protectedSettings);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model DeploymentExtensionSpec"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

