/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.WorkspaceInner;
import com.azure.resourcemanager.loganalytics.models.Identity;
import com.azure.resourcemanager.loganalytics.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.loganalytics.models.PublicNetworkAccessType;
import com.azure.resourcemanager.loganalytics.models.SystemDataAutoGenerated;
import com.azure.resourcemanager.loganalytics.models.WorkspaceCapping;
import com.azure.resourcemanager.loganalytics.models.WorkspaceEntityStatus;
import com.azure.resourcemanager.loganalytics.models.WorkspaceFeatures;
import com.azure.resourcemanager.loganalytics.models.WorkspaceSku;
import java.util.List;
import java.util.Map;

public interface Workspace {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public Identity identity();

    public SystemDataAutoGenerated systemData();

    public String etag();

    public WorkspaceEntityStatus provisioningState();

    public String customerId();

    public WorkspaceSku sku();

    public Integer retentionInDays();

    public WorkspaceCapping workspaceCapping();

    public String createdDate();

    public String modifiedDate();

    public PublicNetworkAccessType publicNetworkAccessForIngestion();

    public PublicNetworkAccessType publicNetworkAccessForQuery();

    public Boolean forceCmkForQuery();

    public List<PrivateLinkScopedResource> privateLinkScopedResources();

    public WorkspaceFeatures features();

    public String defaultDataCollectionRuleResourceId();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public WorkspaceInner innerModel();

    public Update update();

    public Workspace refresh();

    public Workspace refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDefaultDataCollectionRuleResourceId {
            public Update withDefaultDataCollectionRuleResourceId(String var1);
        }

        public static interface WithFeatures {
            public Update withFeatures(WorkspaceFeatures var1);
        }

        public static interface WithForceCmkForQuery {
            public Update withForceCmkForQuery(Boolean var1);
        }

        public static interface WithPublicNetworkAccessForQuery {
            public Update withPublicNetworkAccessForQuery(PublicNetworkAccessType var1);
        }

        public static interface WithPublicNetworkAccessForIngestion {
            public Update withPublicNetworkAccessForIngestion(PublicNetworkAccessType var1);
        }

        public static interface WithWorkspaceCapping {
            public Update withWorkspaceCapping(WorkspaceCapping var1);
        }

        public static interface WithRetentionInDays {
            public Update withRetentionInDays(Integer var1);
        }

        public static interface WithSku {
            public Update withSku(WorkspaceSku var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(Identity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithSku,
    UpdateStages.WithRetentionInDays,
    UpdateStages.WithWorkspaceCapping,
    UpdateStages.WithPublicNetworkAccessForIngestion,
    UpdateStages.WithPublicNetworkAccessForQuery,
    UpdateStages.WithForceCmkForQuery,
    UpdateStages.WithFeatures,
    UpdateStages.WithDefaultDataCollectionRuleResourceId {
        public Workspace apply();

        public Workspace apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDefaultDataCollectionRuleResourceId {
            public WithCreate withDefaultDataCollectionRuleResourceId(String var1);
        }

        public static interface WithFeatures {
            public WithCreate withFeatures(WorkspaceFeatures var1);
        }

        public static interface WithForceCmkForQuery {
            public WithCreate withForceCmkForQuery(Boolean var1);
        }

        public static interface WithPublicNetworkAccessForQuery {
            public WithCreate withPublicNetworkAccessForQuery(PublicNetworkAccessType var1);
        }

        public static interface WithPublicNetworkAccessForIngestion {
            public WithCreate withPublicNetworkAccessForIngestion(PublicNetworkAccessType var1);
        }

        public static interface WithWorkspaceCapping {
            public WithCreate withWorkspaceCapping(WorkspaceCapping var1);
        }

        public static interface WithRetentionInDays {
            public WithCreate withRetentionInDays(Integer var1);
        }

        public static interface WithSku {
            public WithCreate withSku(WorkspaceSku var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(Identity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithEtag,
        WithSku,
        WithRetentionInDays,
        WithWorkspaceCapping,
        WithPublicNetworkAccessForIngestion,
        WithPublicNetworkAccessForQuery,
        WithForceCmkForQuery,
        WithFeatures,
        WithDefaultDataCollectionRuleResourceId {
            public Workspace create();

            public Workspace create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

