/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.VirtualHubRouteTableV2SClient;
import com.azure.resourcemanager.network.fluent.models.VirtualHubRouteTableV2Inner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ErrorException;
import com.azure.resourcemanager.network.models.ListVirtualHubRouteTableV2SResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VirtualHubRouteTableV2SClientImpl
implements VirtualHubRouteTableV2SClient {
    private final VirtualHubRouteTableV2SService service;
    private final NetworkManagementClientImpl client;

    VirtualHubRouteTableV2SClientImpl(NetworkManagementClientImpl client) {
        this.service = (VirtualHubRouteTableV2SService)RestProxy.create(VirtualHubRouteTableV2SService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualHubRouteTableV2Inner>> getWithResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeTableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeTableName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2023-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualHubRouteTableV2Inner>> getWithResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeTableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeTableName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2023-09-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualHubRouteTableV2Inner> getAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        return this.getWithResponseAsync(resourceGroupName, virtualHubName, routeTableName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VirtualHubRouteTableV2Inner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualHubRouteTableV2Inner> getWithResponse(String resourceGroupName, String virtualHubName, String routeTableName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, virtualHubName, routeTableName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualHubRouteTableV2Inner get(String resourceGroupName, String virtualHubName, String routeTableName) {
        return (VirtualHubRouteTableV2Inner)((Object)this.getWithResponse(resourceGroupName, virtualHubName, routeTableName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeTableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeTableName is required and cannot be null."));
        }
        if (virtualHubRouteTableV2Parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubRouteTableV2Parameters is required and cannot be null."));
        }
        virtualHubRouteTableV2Parameters.validate();
        String apiVersion = "2023-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2023-09-01", virtualHubRouteTableV2Parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeTableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeTableName is required and cannot be null."));
        }
        if (virtualHubRouteTableV2Parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubRouteTableV2Parameters is required and cannot be null."));
        }
        virtualHubRouteTableV2Parameters.validate();
        String apiVersion = "2023-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2023-09-01", virtualHubRouteTableV2Parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualHubRouteTableV2Inner.class), (Type)((Object)VirtualHubRouteTableV2Inner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualHubRouteTableV2Inner.class), (Type)((Object)VirtualHubRouteTableV2Inner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner> beginCreateOrUpdate(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner> beginCreateOrUpdate(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualHubRouteTableV2Inner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualHubRouteTableV2Inner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualHubRouteTableV2Inner createOrUpdate(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return (VirtualHubRouteTableV2Inner)((Object)this.createOrUpdateAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualHubRouteTableV2Inner createOrUpdate(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, Context context) {
        return (VirtualHubRouteTableV2Inner)((Object)this.createOrUpdateAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeTableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeTableName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2023-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeTableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeTableName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2023-09-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualHubName, routeTableName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String routeTableName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualHubName, routeTableName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualHubName, String routeTableName) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routeTableName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualHubName, String routeTableName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routeTableName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routeTableName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routeTableName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routeTableName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String routeTableName) {
        this.deleteAsync(resourceGroupName, virtualHubName, routeTableName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String routeTableName, Context context) {
        this.deleteAsync(resourceGroupName, virtualHubName, routeTableName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualHubRouteTableV2Inner>> listSinglePageAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, "2023-09-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListVirtualHubRouteTableV2SResult)res.getValue()).value(), ((ListVirtualHubRouteTableV2SResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualHubRouteTableV2Inner>> listSinglePageAsync(String resourceGroupName, String virtualHubName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, "2023-09-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListVirtualHubRouteTableV2SResult)res.getValue()).value(), ((ListVirtualHubRouteTableV2SResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualHubRouteTableV2Inner> listAsync(String resourceGroupName, String virtualHubName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, virtualHubName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualHubRouteTableV2Inner> listAsync(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, virtualHubName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualHubRouteTableV2Inner> list(String resourceGroupName, String virtualHubName) {
        return new PagedIterable(this.listAsync(resourceGroupName, virtualHubName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualHubRouteTableV2Inner> list(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, virtualHubName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualHubRouteTableV2Inner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListVirtualHubRouteTableV2SResult)res.getValue()).value(), ((ListVirtualHubRouteTableV2SResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualHubRouteTableV2Inner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListVirtualHubRouteTableV2SResult)res.getValue()).value(), ((ListVirtualHubRouteTableV2SResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface VirtualHubRouteTableV2SService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<VirtualHubRouteTableV2Inner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @PathParam(value="routeTableName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @PathParam(value="routeTableName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") VirtualHubRouteTableV2Inner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @PathParam(value="routeTableName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListVirtualHubRouteTableV2SResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListVirtualHubRouteTableV2SResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

