/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.Resource;
import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.azure.resourcemanager.network.fluent.models.WebApplicationFirewallPolicyInner;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.KnownWebApplicationGatewayManagedRuleSet;
import com.azure.resourcemanager.network.models.ManagedRuleGroupOverride;
import com.azure.resourcemanager.network.models.ManagedRuleSet;
import com.azure.resourcemanager.network.models.ManagedRulesDefinition;
import com.azure.resourcemanager.network.models.OwaspCrsExclusionEntry;
import com.azure.resourcemanager.network.models.PolicySettings;
import com.azure.resourcemanager.network.models.WebApplicationFirewallEnabledState;
import com.azure.resourcemanager.network.models.WebApplicationFirewallMode;
import com.azure.resourcemanager.network.models.WebApplicationFirewallPolicy;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebApplicationFirewallPolicyImpl
extends GroupableResourceImpl<WebApplicationFirewallPolicy, WebApplicationFirewallPolicyInner, WebApplicationFirewallPolicyImpl, NetworkManager>
implements WebApplicationFirewallPolicy,
WebApplicationFirewallPolicy.Definition,
WebApplicationFirewallPolicy.Update,
WebApplicationFirewallPolicy.UpdateStages.WithRequestBodyOrUpdate {
    private static final String BOT_DETECTION_RULE_SET_TYPE = "Microsoft_BotManagerRuleSet";
    private static final String BOT_DETECTION_RULE_SET_VERSION_DEFAULT = "0.1";

    protected WebApplicationFirewallPolicyImpl(String name, WebApplicationFirewallPolicyInner innerObject, NetworkManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
    }

    @Override
    public WebApplicationFirewallMode mode() {
        if (((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).policySettings() == null) {
            return null;
        }
        return ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).policySettings().mode();
    }

    @Override
    public boolean isRequestBodyInspectionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).policySettings().requestBodyCheck());
    }

    @Override
    public Integer requestBodySizeLimitInKb() {
        return ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).policySettings().requestBodyInspectLimitInKB();
    }

    @Override
    public Integer fileUploadSizeLimitInMb() {
        return ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).policySettings().fileUploadLimitInMb();
    }

    @Override
    public PolicySettings getPolicySettings() {
        return ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).policySettings();
    }

    @Override
    public ManagedRulesDefinition getManagedRules() {
        return ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).managedRules();
    }

    @Override
    public boolean isEnabled() {
        return WebApplicationFirewallEnabledState.ENABLED.equals((Object)((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).policySettings().state());
    }

    @Override
    public List<String> getAssociatedApplicationGatewayIds() {
        if (CoreUtils.isNullOrEmpty(((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).applicationGateways())) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).applicationGateways().stream().map(ApplicationGatewayInner::id).collect(Collectors.toList()));
    }

    @Override
    public List<ApplicationGateway> getAssociatedApplicationGateways() {
        List associatedGateways = (List)this.getAssociatedApplicationGatewaysAsync().collectList().block();
        if (associatedGateways == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(associatedGateways);
    }

    @Override
    public Flux<ApplicationGateway> getAssociatedApplicationGatewaysAsync() {
        return Flux.fromIterable(this.getAssociatedApplicationGatewayIds()).flatMap(applicationGatewayId -> ((NetworkManager)this.manager()).applicationGateways().getByIdAsync((String)applicationGatewayId));
    }

    @Override
    public WebApplicationFirewallPolicyImpl withDetectionMode() {
        return this.withMode(WebApplicationFirewallMode.DETECTION);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withPreventionMode() {
        return this.withMode(WebApplicationFirewallMode.PREVENTION);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withMode(WebApplicationFirewallMode mode) {
        this.ensurePolicySettings().withMode(mode);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl enablePolicy() {
        this.ensurePolicySettings().withState(WebApplicationFirewallEnabledState.ENABLED);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl disablePolicy() {
        this.ensurePolicySettings().withState(WebApplicationFirewallEnabledState.DISABLED);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withBotProtection() {
        return this.withBotProtection(BOT_DETECTION_RULE_SET_VERSION_DEFAULT);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withoutBotProtection() {
        this.ensureManagedRules().managedRuleSets().removeIf(ruleSet -> BOT_DETECTION_RULE_SET_TYPE.equals(ruleSet.ruleSetType()));
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withBotProtection(String version) {
        String versionOrDefault = CoreUtils.isNullOrEmpty((CharSequence)version) ? BOT_DETECTION_RULE_SET_VERSION_DEFAULT : version;
        Optional<ManagedRuleSet> ruleSetOptional = this.ensureManagedRules().managedRuleSets().stream().filter(ruleSet -> BOT_DETECTION_RULE_SET_TYPE.equals(ruleSet.ruleSetType())).findFirst();
        if (ruleSetOptional.isPresent()) {
            ManagedRuleSet ruleSet2 = ruleSetOptional.get();
            if (version != null) {
                ruleSet2.withRuleSetVersion(version);
            }
        } else {
            this.ensureManagedRules().managedRuleSets().add(new ManagedRuleSet().withRuleSetType(BOT_DETECTION_RULE_SET_TYPE).withRuleSetVersion(versionOrDefault));
        }
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl enableRequestBodyInspection() {
        this.ensurePolicySettings().withRequestBodyCheck(true);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl disableRequestBodyInspection() {
        this.ensurePolicySettings().withRequestBodyCheck(false);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withRequestBodySizeLimitInKb(int limitInKb) {
        this.ensurePolicySettings().withRequestBodyInspectLimitInKB(limitInKb).withMaxRequestBodySizeInKb(limitInKb);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withFileUploadSizeLimitInMb(int limitInMb) {
        this.ensurePolicySettings().withFileUploadLimitInMb(limitInMb);
        return this;
    }

    public Mono<WebApplicationFirewallPolicy> createResourceAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getWebApplicationFirewallPolicies().createOrUpdateAsync(this.resourceGroupName(), this.name(), (WebApplicationFirewallPolicyInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public WebApplicationFirewallPolicyImpl withManagedRuleSet(KnownWebApplicationGatewayManagedRuleSet managedRuleSet, ManagedRuleGroupOverride ... managedRuleGroupOverrides) {
        Objects.requireNonNull(managedRuleSet);
        return this.withManagedRuleSet(managedRuleSet.type(), managedRuleSet.version(), managedRuleGroupOverrides);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withManagedRuleSet(String type, String version, ManagedRuleGroupOverride ... managedRuleGroupOverrides) {
        ManagedRuleSet managedRuleSet = new ManagedRuleSet().withRuleSetType(type).withRuleSetVersion(version);
        if (managedRuleGroupOverrides != null) {
            managedRuleSet.withRuleGroupOverrides(Arrays.stream(managedRuleGroupOverrides).collect(Collectors.toList()));
        }
        return this.withManagedRuleSet(managedRuleSet);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withManagedRuleSet(ManagedRuleSet managedRuleSet) {
        Objects.requireNonNull(managedRuleSet);
        ManagedRulesDefinition managedRules = this.ensureManagedRules();
        this.withoutManagedRuleSet(managedRuleSet.ruleSetType(), managedRuleSet.ruleSetVersion());
        managedRules.managedRuleSets().add(managedRuleSet);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withoutManagedRuleSet(KnownWebApplicationGatewayManagedRuleSet managedRuleSet) {
        Objects.requireNonNull(managedRuleSet);
        return this.withoutManagedRuleSet(managedRuleSet.type(), managedRuleSet.version());
    }

    @Override
    public WebApplicationFirewallPolicyImpl withoutManagedRuleSet(String type, String version) {
        if (((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).managedRules() != null && ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).managedRules().managedRuleSets() != null) {
            ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).managedRules().managedRuleSets().removeIf(ruleSet -> Objects.equals(type, ruleSet.ruleSetType()) && Objects.equals(version, ruleSet.ruleSetVersion()));
        }
        return this;
    }

    protected Mono<WebApplicationFirewallPolicyInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getWebApplicationFirewallPolicies().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private PolicySettings ensurePolicySettings() {
        if (((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).policySettings() == null) {
            PolicySettings policySettings = new PolicySettings();
            ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).withPolicySettings(policySettings);
        }
        return ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).policySettings();
    }

    private ManagedRulesDefinition ensureManagedRules() {
        ManagedRulesDefinition managedRulesDefinition = ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).managedRules();
        if (managedRulesDefinition == null) {
            managedRulesDefinition = new ManagedRulesDefinition();
            ((WebApplicationFirewallPolicyInner)((Object)this.innerModel())).withManagedRules(managedRulesDefinition);
            if (managedRulesDefinition.managedRuleSets() == null) {
                managedRulesDefinition.withManagedRuleSets(new ArrayList<ManagedRuleSet>());
            }
            if (managedRulesDefinition.exclusions() == null) {
                managedRulesDefinition.withExclusions(new ArrayList<OwaspCrsExclusionEntry>());
            }
        }
        return managedRulesDefinition;
    }
}

