/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.models.ApplicationSecurityGroup;
import com.azure.resourcemanager.network.models.DeleteOptions;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkInterfaceBase;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.UpdatableWithTags;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.util.Map;

public interface NetworkInterface
extends NetworkInterfaceBase,
GroupableResource<NetworkManager, NetworkInterfaceInner>,
Refreshable<NetworkInterface>,
Updatable<Update>,
UpdatableWithTags<NetworkInterface> {
    public Map<String, NicIpConfiguration> ipConfigurations();

    public NicIpConfiguration primaryIPConfiguration();

    public static interface Update
    extends Appliable<NetworkInterface>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithPrimaryNetworkSubnet,
    UpdateStages.WithPrimaryPrivateIP,
    UpdateStages.WithPrimaryPublicIPAddress,
    UpdateStages.WithNetworkSecurityGroup,
    UpdateStages.WithIPForwarding,
    UpdateStages.WithDnsServer,
    UpdateStages.WithIPConfiguration,
    UpdateStages.WithLoadBalancer,
    UpdateStages.WithAcceleratedNetworking,
    UpdateStages.WithApplicationSecurityGroup,
    UpdateStages.WithPublicIPAddressDeleteOptions {
    }

    public static interface UpdateStages {

        public static interface WithPublicIPAddressDeleteOptions {
            public Update withPrimaryPublicIPAddressDeleteOptions(DeleteOptions var1);
        }

        public static interface WithLoadBalancer {
            public Update withExistingLoadBalancerBackend(LoadBalancer var1, String var2);

            public Update withExistingLoadBalancerInboundNatRule(LoadBalancer var1, String var2);

            public Update withoutLoadBalancerBackends();

            public Update withoutLoadBalancerInboundNatRules();
        }

        public static interface WithAcceleratedNetworking {
            public Update withAcceleratedNetworking();

            public Update withoutAcceleratedNetworking();
        }

        public static interface WithIPConfiguration {
            public NicIpConfiguration.UpdateDefinitionStages.Blank<Update> defineSecondaryIPConfiguration(String var1);

            public NicIpConfiguration.Update updateIPConfiguration(String var1);

            public Update withoutIPConfiguration(String var1);
        }

        public static interface WithDnsServer {
            public Update withDnsServer(String var1);

            public Update withoutDnsServer(String var1);

            public Update withAzureDnsServer();
        }

        public static interface WithIPForwarding {
            public Update withIPForwarding();

            public Update withoutIPForwarding();
        }

        public static interface WithApplicationSecurityGroup {
            public Update withExistingApplicationSecurityGroup(ApplicationSecurityGroup var1);

            public Update withoutApplicationSecurityGroup(String var1);
        }

        public static interface WithNetworkSecurityGroup {
            public Update withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> var1);

            public Update withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);

            public Update withoutNetworkSecurityGroup();
        }

        public static interface WithPrimaryPublicIPAddress {
            public Update withNewPrimaryPublicIPAddress(Creatable<PublicIpAddress> var1);

            public Update withNewPrimaryPublicIPAddress();

            public Update withNewPrimaryPublicIPAddress(String var1);

            public Update withoutPrimaryPublicIPAddress();

            public Update withExistingPrimaryPublicIPAddress(PublicIpAddress var1);
        }

        public static interface WithPrimaryPrivateIP {
            public Update withPrimaryPrivateIPAddressDynamic();

            public Update withPrimaryPrivateIPAddressStatic(String var1);
        }

        public static interface WithPrimaryNetworkSubnet {
            public Update withSubnet(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<NetworkInterface>,
        Resource.DefinitionWithTags<WithCreate>,
        WithPrimaryPublicIPAddress,
        WithNetworkSecurityGroup,
        WithSecondaryIPConfiguration,
        WithAcceleratedNetworking,
        WithLoadBalancer,
        WithApplicationSecurityGroup,
        WithPublicIPAddressDeleteOptions {
            public WithCreate withIPForwarding();

            public WithCreate withDnsServer(String var1);

            public WithCreate withInternalDnsNameLabel(String var1);

            public Accepted<NetworkInterface> beginCreate();
        }

        public static interface WithPublicIPAddressDeleteOptions {
            public WithCreate withPrimaryPublicIPAddressDeleteOptions(DeleteOptions var1);
        }

        public static interface WithAcceleratedNetworking {
            public WithCreate withAcceleratedNetworking();
        }

        public static interface WithSecondaryIPConfiguration {
            public NicIpConfiguration.DefinitionStages.Blank<WithCreate> defineSecondaryIPConfiguration(String var1);
        }

        public static interface WithApplicationSecurityGroup {
            public WithCreate withExistingApplicationSecurityGroup(ApplicationSecurityGroup var1);
        }

        public static interface WithNetworkSecurityGroup {
            public WithCreate withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> var1);

            public WithCreate withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);
        }

        public static interface WithPrimaryPublicIPAddress {
            public WithCreate withNewPrimaryPublicIPAddress(Creatable<PublicIpAddress> var1);

            public WithCreate withNewPrimaryPublicIPAddress();

            public WithCreate withNewPrimaryPublicIPAddress(String var1);

            public WithCreate withExistingPrimaryPublicIPAddress(PublicIpAddress var1);
        }

        public static interface WithPrimaryPrivateIP {
            public WithCreate withPrimaryPrivateIPAddressDynamic();

            public WithCreate withPrimaryPrivateIPAddressStatic(String var1);
        }

        public static interface WithPrimaryNetworkSubnet {
            public WithPrimaryPrivateIP withSubnet(String var1);
        }

        public static interface WithPrimaryNetwork {
            public WithPrimaryPrivateIP withNewPrimaryNetwork(Creatable<Network> var1);

            public WithPrimaryPrivateIP withNewPrimaryNetwork(String var1, String var2);

            public WithPrimaryPrivateIP withNewPrimaryNetwork(String var1);

            public WithPrimaryNetworkSubnet withExistingPrimaryNetwork(Network var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithPrimaryNetwork> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }

        public static interface WithLoadBalancer {
            public WithCreate withExistingLoadBalancerBackend(LoadBalancer var1, String var2);

            public WithCreate withExistingLoadBalancerInboundNatRule(LoadBalancer var1, String var2);
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithPrimaryNetwork,
    DefinitionStages.WithPrimaryNetworkSubnet,
    DefinitionStages.WithPrimaryPrivateIP,
    DefinitionStages.WithCreate {
    }
}

