/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.RouteTableInner;
import com.azure.resourcemanager.network.models.HasAssociatedSubnets;
import com.azure.resourcemanager.network.models.Route;
import com.azure.resourcemanager.network.models.RouteNextHopType;
import com.azure.resourcemanager.network.models.UpdatableWithTags;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.util.Map;

public interface RouteTable
extends GroupableResource<NetworkManager, RouteTableInner>,
Refreshable<RouteTable>,
Updatable<Update>,
UpdatableWithTags<RouteTable>,
HasAssociatedSubnets {
    public Map<String, Route> routes();

    public boolean isBgpRoutePropagationDisabled();

    public static interface Update
    extends Appliable<RouteTable>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithRoute,
    UpdateStages.WithBgpRoutePropagation {
    }

    public static interface UpdateStages {

        public static interface WithBgpRoutePropagation {
            public Update withDisableBgpRoutePropagation();

            public Update withEnableBgpRoutePropagation();
        }

        public static interface WithRoute {
            public Update withRoute(String var1, RouteNextHopType var2);

            public Update withRouteViaVirtualAppliance(String var1, String var2);

            public Route.UpdateDefinitionStages.Blank<Update> defineRoute(String var1);

            public Update withoutRoute(String var1);

            public Route.Update updateRoute(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<RouteTable>,
        Resource.DefinitionWithTags<WithCreate>,
        WithRoute,
        WithBgpRoutePropagation {
        }

        public static interface WithBgpRoutePropagation {
            public WithCreate withDisableBgpRoutePropagation();
        }

        public static interface WithRoute {
            public Route.DefinitionStages.Blank<WithCreate> defineRoute(String var1);

            public WithCreate withRoute(String var1, RouteNextHopType var2);

            public WithCreate withRouteViaVirtualAppliance(String var1, String var2);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate {
    }
}

