/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.recoveryservices.fluent.RecoveryServicesClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.CapabilitiesResponseInner;
import com.azure.resourcemanager.recoveryservices.fluent.models.CheckNameAvailabilityResultInner;
import com.azure.resourcemanager.recoveryservices.implementation.RecoveryServicesManagementClientImpl;
import com.azure.resourcemanager.recoveryservices.models.CheckNameAvailabilityParameters;
import com.azure.resourcemanager.recoveryservices.models.ResourceCapabilities;
import reactor.core.publisher.Mono;

public final class RecoveryServicesClientImpl
implements RecoveryServicesClient {
    private final RecoveryServicesService service;
    private final RecoveryServicesManagementClientImpl client;

    RecoveryServicesClientImpl(RecoveryServicesManagementClientImpl client) {
        this.service = (RecoveryServicesService)RestProxy.create(RecoveryServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithResponseAsync(String resourceGroupName, String location, CheckNameAvailabilityParameters input) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (input == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter input is required and cannot be null."));
        }
        input.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), location, input, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithResponseAsync(String resourceGroupName, String location, CheckNameAvailabilityParameters input, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (input == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter input is required and cannot be null."));
        }
        input.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkNameAvailability(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), location, input, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String resourceGroupName, String location, CheckNameAvailabilityParameters input) {
        return this.checkNameAvailabilityWithResponseAsync(resourceGroupName, location, input).flatMap(res -> Mono.justOrEmpty((Object)((CheckNameAvailabilityResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckNameAvailabilityResultInner> checkNameAvailabilityWithResponse(String resourceGroupName, String location, CheckNameAvailabilityParameters input, Context context) {
        return (Response)this.checkNameAvailabilityWithResponseAsync(resourceGroupName, location, input, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckNameAvailabilityResultInner checkNameAvailability(String resourceGroupName, String location, CheckNameAvailabilityParameters input) {
        return (CheckNameAvailabilityResultInner)this.checkNameAvailabilityWithResponse(resourceGroupName, location, input, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CapabilitiesResponseInner>> capabilitiesWithResponseAsync(String location, ResourceCapabilities input) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (input == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter input is required and cannot be null."));
        }
        input.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.capabilities(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), location, input, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CapabilitiesResponseInner>> capabilitiesWithResponseAsync(String location, ResourceCapabilities input, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (input == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter input is required and cannot be null."));
        }
        input.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.capabilities(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), location, input, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CapabilitiesResponseInner> capabilitiesAsync(String location, ResourceCapabilities input) {
        return this.capabilitiesWithResponseAsync(location, input).flatMap(res -> Mono.justOrEmpty((Object)((CapabilitiesResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CapabilitiesResponseInner> capabilitiesWithResponse(String location, ResourceCapabilities input, Context context) {
        return (Response)this.capabilitiesWithResponseAsync(location, input, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapabilitiesResponseInner capabilities(String location, ResourceCapabilities input) {
        return (CapabilitiesResponseInner)this.capabilitiesWithResponse(location, input, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="RecoveryServicesMana")
    public static interface RecoveryServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/locations/{location}/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailability(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="location") String var5, @BodyParam(value="application/json") CheckNameAvailabilityParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.RecoveryServices/locations/{location}/capabilities")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CapabilitiesResponseInner>> capabilities(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="location") String var4, @BodyParam(value="application/json") ResourceCapabilities var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

