/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.RecoveryServicesClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.CapabilitiesResponseInner;
import com.azure.resourcemanager.recoveryservices.fluent.models.CheckNameAvailabilityResultInner;
import com.azure.resourcemanager.recoveryservices.implementation.CapabilitiesResponseImpl;
import com.azure.resourcemanager.recoveryservices.implementation.CheckNameAvailabilityResultImpl;
import com.azure.resourcemanager.recoveryservices.models.CapabilitiesResponse;
import com.azure.resourcemanager.recoveryservices.models.CheckNameAvailabilityParameters;
import com.azure.resourcemanager.recoveryservices.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.recoveryservices.models.RecoveryServices;
import com.azure.resourcemanager.recoveryservices.models.ResourceCapabilities;

public final class RecoveryServicesImpl
implements RecoveryServices {
    private static final ClientLogger LOGGER = new ClientLogger(RecoveryServicesImpl.class);
    private final RecoveryServicesClient innerClient;
    private final RecoveryServicesManager serviceManager;

    public RecoveryServicesImpl(RecoveryServicesClient innerClient, RecoveryServicesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CheckNameAvailabilityResult> checkNameAvailabilityWithResponse(String resourceGroupName, String location, CheckNameAvailabilityParameters input, Context context) {
        Response<CheckNameAvailabilityResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, location, input, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameAvailabilityResultImpl((CheckNameAvailabilityResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String resourceGroupName, String location, CheckNameAvailabilityParameters input) {
        CheckNameAvailabilityResultInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, location, input);
        if (inner != null) {
            return new CheckNameAvailabilityResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<CapabilitiesResponse> capabilitiesWithResponse(String location, ResourceCapabilities input, Context context) {
        Response<CapabilitiesResponseInner> inner = this.serviceClient().capabilitiesWithResponse(location, input, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CapabilitiesResponseImpl((CapabilitiesResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CapabilitiesResponse capabilities(String location, ResourceCapabilities input) {
        CapabilitiesResponseInner inner = this.serviceClient().capabilities(location, input);
        if (inner != null) {
            return new CapabilitiesResponseImpl(inner, this.manager());
        }
        return null;
    }

    private RecoveryServicesClient serviceClient() {
        return this.innerClient;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }
}

