/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.ReplicationUsagesClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.ReplicationUsageInner;
import com.azure.resourcemanager.recoveryservices.implementation.ReplicationUsageImpl;
import com.azure.resourcemanager.recoveryservices.implementation.Utils;
import com.azure.resourcemanager.recoveryservices.models.ReplicationUsage;
import com.azure.resourcemanager.recoveryservices.models.ReplicationUsages;

public final class ReplicationUsagesImpl
implements ReplicationUsages {
    private static final ClientLogger LOGGER = new ClientLogger(ReplicationUsagesImpl.class);
    private final ReplicationUsagesClient innerClient;
    private final RecoveryServicesManager serviceManager;

    public ReplicationUsagesImpl(ReplicationUsagesClient innerClient, RecoveryServicesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ReplicationUsage> list(String resourceGroupName, String vaultName) {
        PagedIterable<ReplicationUsageInner> inner = this.serviceClient().list(resourceGroupName, vaultName);
        return Utils.mapPage(inner, inner1 -> new ReplicationUsageImpl((ReplicationUsageInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReplicationUsage> list(String resourceGroupName, String vaultName, Context context) {
        PagedIterable<ReplicationUsageInner> inner = this.serviceClient().list(resourceGroupName, vaultName, context);
        return Utils.mapPage(inner, inner1 -> new ReplicationUsageImpl((ReplicationUsageInner)inner1, this.manager()));
    }

    private ReplicationUsagesClient serviceClient() {
        return this.innerClient;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }
}

