/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.recoveryservices.fluent.VaultCertificatesClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.VaultCertificateResponseInner;
import com.azure.resourcemanager.recoveryservices.implementation.RecoveryServicesManagementClientImpl;
import com.azure.resourcemanager.recoveryservices.models.CertificateRequest;
import reactor.core.publisher.Mono;

public final class VaultCertificatesClientImpl
implements VaultCertificatesClient {
    private final VaultCertificatesService service;
    private final RecoveryServicesManagementClientImpl client;

    VaultCertificatesClientImpl(RecoveryServicesManagementClientImpl client) {
        this.service = (VaultCertificatesService)RestProxy.create(VaultCertificatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VaultCertificateResponseInner>> createWithResponseAsync(String resourceGroupName, String vaultName, String certificateName, CertificateRequest certificateRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (certificateRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateRequest is required and cannot be null."));
        }
        certificateRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, vaultName, certificateName, certificateRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VaultCertificateResponseInner>> createWithResponseAsync(String resourceGroupName, String vaultName, String certificateName, CertificateRequest certificateRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (certificateRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateRequest is required and cannot be null."));
        }
        certificateRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, vaultName, certificateName, certificateRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VaultCertificateResponseInner> createAsync(String resourceGroupName, String vaultName, String certificateName, CertificateRequest certificateRequest) {
        return this.createWithResponseAsync(resourceGroupName, vaultName, certificateName, certificateRequest).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VaultCertificateResponseInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VaultCertificateResponseInner> createWithResponse(String resourceGroupName, String vaultName, String certificateName, CertificateRequest certificateRequest, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, vaultName, certificateName, certificateRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VaultCertificateResponseInner create(String resourceGroupName, String vaultName, String certificateName, CertificateRequest certificateRequest) {
        return (VaultCertificateResponseInner)((Object)this.createWithResponse(resourceGroupName, vaultName, certificateName, certificateRequest, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="RecoveryServicesMana")
    public static interface VaultCertificatesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/certificates/{certificateName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultCertificateResponseInner>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="certificateName") String var6, @BodyParam(value="application/json") CertificateRequest var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

