/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.VaultExtendedInfoesClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.VaultExtendedInfoResourceInner;
import com.azure.resourcemanager.recoveryservices.implementation.VaultExtendedInfoResourceImpl;
import com.azure.resourcemanager.recoveryservices.models.VaultExtendedInfoResource;
import com.azure.resourcemanager.recoveryservices.models.VaultExtendedInfoes;

public final class VaultExtendedInfoesImpl
implements VaultExtendedInfoes {
    private static final ClientLogger LOGGER = new ClientLogger(VaultExtendedInfoesImpl.class);
    private final VaultExtendedInfoesClient innerClient;
    private final RecoveryServicesManager serviceManager;

    public VaultExtendedInfoesImpl(VaultExtendedInfoesClient innerClient, RecoveryServicesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VaultExtendedInfoResource> getWithResponse(String resourceGroupName, String vaultName, Context context) {
        Response<VaultExtendedInfoResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VaultExtendedInfoResourceImpl((VaultExtendedInfoResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VaultExtendedInfoResource get(String resourceGroupName, String vaultName) {
        VaultExtendedInfoResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName);
        if (inner != null) {
            return new VaultExtendedInfoResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<VaultExtendedInfoResource> createOrUpdateWithResponse(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails, Context context) {
        Response<VaultExtendedInfoResourceInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, vaultName, resourceExtendedInfoDetails, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VaultExtendedInfoResourceImpl((VaultExtendedInfoResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VaultExtendedInfoResource createOrUpdate(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails) {
        VaultExtendedInfoResourceInner inner = this.serviceClient().createOrUpdate(resourceGroupName, vaultName, resourceExtendedInfoDetails);
        if (inner != null) {
            return new VaultExtendedInfoResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<VaultExtendedInfoResource> updateWithResponse(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails, Context context) {
        Response<VaultExtendedInfoResourceInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, vaultName, resourceExtendedInfoDetails, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VaultExtendedInfoResourceImpl((VaultExtendedInfoResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VaultExtendedInfoResource update(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails) {
        VaultExtendedInfoResourceInner inner = this.serviceClient().update(resourceGroupName, vaultName, resourceExtendedInfoDetails);
        if (inner != null) {
            return new VaultExtendedInfoResourceImpl(inner, this.manager());
        }
        return null;
    }

    private VaultExtendedInfoesClient serviceClient() {
        return this.innerClient;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }
}

