/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.models.ResourceIdentityType;
import com.azure.resourcemanager.recoveryservices.models.UserIdentity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class IdentityData {
    @JsonProperty(value="principalId", access=JsonProperty.Access.WRITE_ONLY)
    private String principalId;
    @JsonProperty(value="tenantId", access=JsonProperty.Access.WRITE_ONLY)
    private String tenantId;
    @JsonProperty(value="type", required=true)
    private ResourceIdentityType type;
    @JsonProperty(value="userAssignedIdentities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, UserIdentity> userAssignedIdentities;
    private static final ClientLogger LOGGER = new ClientLogger(IdentityData.class);

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ResourceIdentityType type() {
        return this.type;
    }

    public IdentityData withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public IdentityData withUserAssignedIdentities(Map<String, UserIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model IdentityData"));
        }
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

