/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.models.ResourceCertificateDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="authType")
@JsonTypeName(value="AzureActiveDirectory")
public final class ResourceCertificateAndAadDetails
extends ResourceCertificateDetails {
    @JsonProperty(value="aadAuthority", required=true)
    private String aadAuthority;
    @JsonProperty(value="aadTenantId", required=true)
    private String aadTenantId;
    @JsonProperty(value="servicePrincipalClientId", required=true)
    private String servicePrincipalClientId;
    @JsonProperty(value="servicePrincipalObjectId", required=true)
    private String servicePrincipalObjectId;
    @JsonProperty(value="azureManagementEndpointAudience", required=true)
    private String azureManagementEndpointAudience;
    @JsonProperty(value="serviceResourceId")
    private String serviceResourceId;
    @JsonProperty(value="aadAudience")
    private String aadAudience;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceCertificateAndAadDetails.class);

    public String aadAuthority() {
        return this.aadAuthority;
    }

    public ResourceCertificateAndAadDetails withAadAuthority(String aadAuthority) {
        this.aadAuthority = aadAuthority;
        return this;
    }

    public String aadTenantId() {
        return this.aadTenantId;
    }

    public ResourceCertificateAndAadDetails withAadTenantId(String aadTenantId) {
        this.aadTenantId = aadTenantId;
        return this;
    }

    public String servicePrincipalClientId() {
        return this.servicePrincipalClientId;
    }

    public ResourceCertificateAndAadDetails withServicePrincipalClientId(String servicePrincipalClientId) {
        this.servicePrincipalClientId = servicePrincipalClientId;
        return this;
    }

    public String servicePrincipalObjectId() {
        return this.servicePrincipalObjectId;
    }

    public ResourceCertificateAndAadDetails withServicePrincipalObjectId(String servicePrincipalObjectId) {
        this.servicePrincipalObjectId = servicePrincipalObjectId;
        return this;
    }

    public String azureManagementEndpointAudience() {
        return this.azureManagementEndpointAudience;
    }

    public ResourceCertificateAndAadDetails withAzureManagementEndpointAudience(String azureManagementEndpointAudience) {
        this.azureManagementEndpointAudience = azureManagementEndpointAudience;
        return this;
    }

    public String serviceResourceId() {
        return this.serviceResourceId;
    }

    public ResourceCertificateAndAadDetails withServiceResourceId(String serviceResourceId) {
        this.serviceResourceId = serviceResourceId;
        return this;
    }

    public String aadAudience() {
        return this.aadAudience;
    }

    public ResourceCertificateAndAadDetails withAadAudience(String aadAudience) {
        this.aadAudience = aadAudience;
        return this;
    }

    @Override
    public ResourceCertificateAndAadDetails withCertificate(byte[] certificate) {
        super.withCertificate(certificate);
        return this;
    }

    @Override
    public ResourceCertificateAndAadDetails withFriendlyName(String friendlyName) {
        super.withFriendlyName(friendlyName);
        return this;
    }

    @Override
    public ResourceCertificateAndAadDetails withIssuer(String issuer) {
        super.withIssuer(issuer);
        return this;
    }

    @Override
    public ResourceCertificateAndAadDetails withResourceId(Long resourceId) {
        super.withResourceId(resourceId);
        return this;
    }

    @Override
    public ResourceCertificateAndAadDetails withSubject(String subject) {
        super.withSubject(subject);
        return this;
    }

    @Override
    public ResourceCertificateAndAadDetails withThumbprint(String thumbprint) {
        super.withThumbprint(thumbprint);
        return this;
    }

    @Override
    public ResourceCertificateAndAadDetails withValidFrom(OffsetDateTime validFrom) {
        super.withValidFrom(validFrom);
        return this;
    }

    @Override
    public ResourceCertificateAndAadDetails withValidTo(OffsetDateTime validTo) {
        super.withValidTo(validTo);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.aadAuthority() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property aadAuthority in model ResourceCertificateAndAadDetails"));
        }
        if (this.aadTenantId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property aadTenantId in model ResourceCertificateAndAadDetails"));
        }
        if (this.servicePrincipalClientId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property servicePrincipalClientId in model ResourceCertificateAndAadDetails"));
        }
        if (this.servicePrincipalObjectId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property servicePrincipalObjectId in model ResourceCertificateAndAadDetails"));
        }
        if (this.azureManagementEndpointAudience() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property azureManagementEndpointAudience in model ResourceCertificateAndAadDetails"));
        }
    }
}

