/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.recoveryservices.fluent.models.VaultInner;
import com.azure.resourcemanager.recoveryservices.models.IdentityData;
import com.azure.resourcemanager.recoveryservices.models.Sku;
import com.azure.resourcemanager.recoveryservices.models.VaultProperties;
import java.util.Map;

public interface Vault {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public IdentityData identity();

    public VaultProperties properties();

    public Sku sku();

    public SystemData systemData();

    public String etag();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public VaultInner innerModel();

    public Update update();

    public Vault refresh();

    public Vault refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIdentity {
            public Update withIdentity(IdentityData var1);
        }

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithProperties {
            public Update withProperties(VaultProperties var1);
        }

        public static interface WithEtag {
            public Update withEtag(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithEtag,
    UpdateStages.WithProperties,
    UpdateStages.WithSku,
    UpdateStages.WithIdentity {
        public Vault apply();

        public Vault apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(VaultProperties var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(IdentityData var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithProperties,
        WithSku,
        WithEtag {
            public Vault create();

            public Vault create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

