/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.models;

import com.azure.resourcemanager.recoveryservices.models.BackupStorageVersion;
import com.azure.resourcemanager.recoveryservices.models.MonitoringSettings;
import com.azure.resourcemanager.recoveryservices.models.PrivateEndpointConnectionVaultProperties;
import com.azure.resourcemanager.recoveryservices.models.PublicNetworkAccess;
import com.azure.resourcemanager.recoveryservices.models.ResourceMoveState;
import com.azure.resourcemanager.recoveryservices.models.RestoreSettings;
import com.azure.resourcemanager.recoveryservices.models.SecureScoreLevel;
import com.azure.resourcemanager.recoveryservices.models.SecuritySettings;
import com.azure.resourcemanager.recoveryservices.models.UpgradeDetails;
import com.azure.resourcemanager.recoveryservices.models.VaultPrivateEndpointState;
import com.azure.resourcemanager.recoveryservices.models.VaultPropertiesEncryption;
import com.azure.resourcemanager.recoveryservices.models.VaultPropertiesMoveDetails;
import com.azure.resourcemanager.recoveryservices.models.VaultPropertiesRedundancySettings;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VaultProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="upgradeDetails")
    private UpgradeDetails upgradeDetails;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionVaultProperties> privateEndpointConnections;
    @JsonProperty(value="privateEndpointStateForBackup", access=JsonProperty.Access.WRITE_ONLY)
    private VaultPrivateEndpointState privateEndpointStateForBackup;
    @JsonProperty(value="privateEndpointStateForSiteRecovery", access=JsonProperty.Access.WRITE_ONLY)
    private VaultPrivateEndpointState privateEndpointStateForSiteRecovery;
    @JsonProperty(value="encryption")
    private VaultPropertiesEncryption encryption;
    @JsonProperty(value="moveDetails")
    private VaultPropertiesMoveDetails moveDetails;
    @JsonProperty(value="moveState", access=JsonProperty.Access.WRITE_ONLY)
    private ResourceMoveState moveState;
    @JsonProperty(value="backupStorageVersion", access=JsonProperty.Access.WRITE_ONLY)
    private BackupStorageVersion backupStorageVersion;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="monitoringSettings")
    private MonitoringSettings monitoringSettings;
    @JsonProperty(value="restoreSettings")
    private RestoreSettings restoreSettings;
    @JsonProperty(value="redundancySettings")
    private VaultPropertiesRedundancySettings redundancySettings;
    @JsonProperty(value="securitySettings")
    private SecuritySettings securitySettings;
    @JsonProperty(value="secureScore", access=JsonProperty.Access.WRITE_ONLY)
    private SecureScoreLevel secureScore;

    public String provisioningState() {
        return this.provisioningState;
    }

    public UpgradeDetails upgradeDetails() {
        return this.upgradeDetails;
    }

    public VaultProperties withUpgradeDetails(UpgradeDetails upgradeDetails) {
        this.upgradeDetails = upgradeDetails;
        return this;
    }

    public List<PrivateEndpointConnectionVaultProperties> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public VaultPrivateEndpointState privateEndpointStateForBackup() {
        return this.privateEndpointStateForBackup;
    }

    public VaultPrivateEndpointState privateEndpointStateForSiteRecovery() {
        return this.privateEndpointStateForSiteRecovery;
    }

    public VaultPropertiesEncryption encryption() {
        return this.encryption;
    }

    public VaultProperties withEncryption(VaultPropertiesEncryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public VaultPropertiesMoveDetails moveDetails() {
        return this.moveDetails;
    }

    public VaultProperties withMoveDetails(VaultPropertiesMoveDetails moveDetails) {
        this.moveDetails = moveDetails;
        return this;
    }

    public ResourceMoveState moveState() {
        return this.moveState;
    }

    public BackupStorageVersion backupStorageVersion() {
        return this.backupStorageVersion;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public VaultProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public MonitoringSettings monitoringSettings() {
        return this.monitoringSettings;
    }

    public VaultProperties withMonitoringSettings(MonitoringSettings monitoringSettings) {
        this.monitoringSettings = monitoringSettings;
        return this;
    }

    public RestoreSettings restoreSettings() {
        return this.restoreSettings;
    }

    public VaultProperties withRestoreSettings(RestoreSettings restoreSettings) {
        this.restoreSettings = restoreSettings;
        return this;
    }

    public VaultPropertiesRedundancySettings redundancySettings() {
        return this.redundancySettings;
    }

    public VaultProperties withRedundancySettings(VaultPropertiesRedundancySettings redundancySettings) {
        this.redundancySettings = redundancySettings;
        return this;
    }

    public SecuritySettings securitySettings() {
        return this.securitySettings;
    }

    public VaultProperties withSecuritySettings(SecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
        return this;
    }

    public SecureScoreLevel secureScore() {
        return this.secureScore;
    }

    public void validate() {
        if (this.upgradeDetails() != null) {
            this.upgradeDetails().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.moveDetails() != null) {
            this.moveDetails().validate();
        }
        if (this.monitoringSettings() != null) {
            this.monitoringSettings().validate();
        }
        if (this.restoreSettings() != null) {
            this.restoreSettings().validate();
        }
        if (this.redundancySettings() != null) {
            this.redundancySettings().validate();
        }
        if (this.securitySettings() != null) {
            this.securitySettings().validate();
        }
    }
}

