/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resourcegraph.models.FacetRequest;
import com.azure.resourcemanager.resourcegraph.models.QueryRequestOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class QueryRequest {
    @JsonProperty(value="subscriptions")
    private List<String> subscriptions;
    @JsonProperty(value="managementGroups")
    private List<String> managementGroups;
    @JsonProperty(value="query", required=true)
    private String query;
    @JsonProperty(value="options")
    private QueryRequestOptions options;
    @JsonProperty(value="facets")
    private List<FacetRequest> facets;
    private static final ClientLogger LOGGER = new ClientLogger(QueryRequest.class);

    public List<String> subscriptions() {
        return this.subscriptions;
    }

    public QueryRequest withSubscriptions(List<String> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public List<String> managementGroups() {
        return this.managementGroups;
    }

    public QueryRequest withManagementGroups(List<String> managementGroups) {
        this.managementGroups = managementGroups;
        return this;
    }

    public String query() {
        return this.query;
    }

    public QueryRequest withQuery(String query) {
        this.query = query;
        return this;
    }

    public QueryRequestOptions options() {
        return this.options;
    }

    public QueryRequest withOptions(QueryRequestOptions options) {
        this.options = options;
        return this;
    }

    public List<FacetRequest> facets() {
        return this.facets;
    }

    public QueryRequest withFacets(List<FacetRequest> facets) {
        this.facets = facets;
        return this;
    }

    public void validate() {
        if (this.query() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property query in model QueryRequest"));
        }
        if (this.options() != null) {
            this.options().validate();
        }
        if (this.facets() != null) {
            this.facets().forEach(e -> e.validate());
        }
    }
}

