/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseMaxPerformanceLevelCapability;
import com.azure.resourcemanager.sql.models.LicenseTypeCapability;
import com.azure.resourcemanager.sql.models.MaintenanceConfigurationCapability;
import com.azure.resourcemanager.sql.models.MaxSizeCapability;
import com.azure.resourcemanager.sql.models.MaxSizeRangeCapability;
import com.azure.resourcemanager.sql.models.PerformanceLevelCapability;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ElasticPoolPerformanceLevelCapability {
    @JsonProperty(value="performanceLevel", access=JsonProperty.Access.WRITE_ONLY)
    private PerformanceLevelCapability performanceLevel;
    @JsonProperty(value="sku", access=JsonProperty.Access.WRITE_ONLY)
    private Sku sku;
    @JsonProperty(value="supportedLicenseTypes", access=JsonProperty.Access.WRITE_ONLY)
    private List<LicenseTypeCapability> supportedLicenseTypes;
    @JsonProperty(value="maxDatabaseCount", access=JsonProperty.Access.WRITE_ONLY)
    private Integer maxDatabaseCount;
    @JsonProperty(value="includedMaxSize", access=JsonProperty.Access.WRITE_ONLY)
    private MaxSizeCapability includedMaxSize;
    @JsonProperty(value="supportedMaxSizes", access=JsonProperty.Access.WRITE_ONLY)
    private List<MaxSizeRangeCapability> supportedMaxSizes;
    @JsonProperty(value="supportedPerDatabaseMaxSizes", access=JsonProperty.Access.WRITE_ONLY)
    private List<MaxSizeRangeCapability> supportedPerDatabaseMaxSizes;
    @JsonProperty(value="supportedPerDatabaseMaxPerformanceLevels", access=JsonProperty.Access.WRITE_ONLY)
    private List<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> supportedPerDatabaseMaxPerformanceLevels;
    @JsonProperty(value="zoneRedundant", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean zoneRedundant;
    @JsonProperty(value="supportedMaintenanceConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private CapabilityStatus status;
    @JsonProperty(value="reason")
    private String reason;

    public PerformanceLevelCapability performanceLevel() {
        return this.performanceLevel;
    }

    public Sku sku() {
        return this.sku;
    }

    public List<LicenseTypeCapability> supportedLicenseTypes() {
        return this.supportedLicenseTypes;
    }

    public Integer maxDatabaseCount() {
        return this.maxDatabaseCount;
    }

    public MaxSizeCapability includedMaxSize() {
        return this.includedMaxSize;
    }

    public List<MaxSizeRangeCapability> supportedMaxSizes() {
        return this.supportedMaxSizes;
    }

    public List<MaxSizeRangeCapability> supportedPerDatabaseMaxSizes() {
        return this.supportedPerDatabaseMaxSizes;
    }

    public List<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> supportedPerDatabaseMaxPerformanceLevels() {
        return this.supportedPerDatabaseMaxPerformanceLevels;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations() {
        return this.supportedMaintenanceConfigurations;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public ElasticPoolPerformanceLevelCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.performanceLevel() != null) {
            this.performanceLevel().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.supportedLicenseTypes() != null) {
            this.supportedLicenseTypes().forEach(e -> e.validate());
        }
        if (this.includedMaxSize() != null) {
            this.includedMaxSize().validate();
        }
        if (this.supportedMaxSizes() != null) {
            this.supportedMaxSizes().forEach(e -> e.validate());
        }
        if (this.supportedPerDatabaseMaxSizes() != null) {
            this.supportedPerDatabaseMaxSizes().forEach(e -> e.validate());
        }
        if (this.supportedPerDatabaseMaxPerformanceLevels() != null) {
            this.supportedPerDatabaseMaxPerformanceLevels().forEach(e -> e.validate());
        }
        if (this.supportedMaintenanceConfigurations() != null) {
            this.supportedMaintenanceConfigurations().forEach(e -> e.validate());
        }
    }
}

