/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.CodeCustomization;
import com.azure.autorest.customization.ConstantCustomization;
import com.azure.autorest.customization.ConstructorCustomization;
import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.JavadocCustomization;
import com.azure.autorest.customization.MethodCustomization;
import com.azure.autorest.customization.PackageCustomization;
import com.azure.autorest.customization.PropertyCustomization;
import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.FileChangeType;
import com.azure.autorest.customization.implementation.ls.models.FileEvent;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import com.azure.autorest.customization.implementation.ls.models.SymbolKind;
import com.azure.autorest.customization.implementation.ls.models.TextEdit;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceEdit;
import com.azure.autorest.customization.models.Position;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ClassCustomization
extends CodeCustomization {
    private static final int INDENT_LENGTH = 4;
    private static final Pattern METHOD_SIGNATURE_PATTERN = Pattern.compile("^\\s*([^/*][\\w\\s]+\\([\\w\\s<>,\\.]*\\))\\s*\\{?$", 8);
    private static final Pattern CONSTRUCTOR_SIGNATURE_PATTERN = Pattern.compile("^\\s*([^/*][\\w\\s]+\\([\\w\\s<>,\\.]*\\))\\s*\\{?$", 8);
    private static final Pattern BLOCK_OPEN = Pattern.compile("\\) *\\{");
    private static final Pattern PUBLIC_MODIFIER = Pattern.compile(" *public ");
    private static final Pattern PRIVATE_MODIFIER = Pattern.compile(" *private ");
    private static final Pattern MEMBER_PARAMS = Pattern.compile("\\(.*\\)");
    private final String packageName;
    private final String className;

    ClassCustomization(Editor editor, EclipseLanguageClient languageClient, String packageName, String className, SymbolInformation classSymbol) {
        super(editor, languageClient, classSymbol);
        this.packageName = packageName;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassCustomization addImports(String ... imports) {
        if (imports != null) {
            return Utils.addImports(Arrays.asList(imports), this, this::refreshSymbol);
        }
        return this;
    }

    public ClassCustomization addStaticBlock(String staticCodeBlock) {
        return this.addStaticBlock(staticCodeBlock, null);
    }

    public ClassCustomization addStaticBlock(String staticCodeBlock, List<String> importsToAdd) {
        if (Utils.isNullOrEmpty((CharSequence)staticCodeBlock)) {
            return this;
        }
        int lastSymbolLine = this.symbol.getLocation().getRange().getStart().getLine();
        Optional<SymbolInformation> lastSymbol = this.languageClient.listDocumentSymbols(this.fileUri).stream().filter(symbol -> symbol.getKind() == SymbolKind.FIELD).reduce((first, second) -> second);
        int indentAmount = 4;
        if (lastSymbol.isPresent()) {
            lastSymbolLine = lastSymbol.get().getLocation().getRange().getStart().getLine();
            indentAmount = Utils.getIndent(this.editor.getFileLine(this.fileName, lastSymbolLine)).length();
        }
        int staticBlockStartLine = lastSymbolLine + 1;
        this.editor.insertBlankLine(this.fileName, staticBlockStartLine, false);
        Position staticBlockPosition = this.editor.insertBlankLineWithIndent(this.fileName, staticBlockStartLine, indentAmount);
        if (!((String)staticCodeBlock).trim().startsWith("static")) {
            staticCodeBlock = "static { " + System.lineSeparator() + (String)staticCodeBlock + System.lineSeparator() + "}";
        }
        this.editor.replaceWithIndentedContent(this.fileName, staticBlockPosition, staticBlockPosition, (String)staticCodeBlock, staticBlockPosition.getCharacter());
        if (importsToAdd != null) {
            return Utils.addImports(importsToAdd, this, this::refreshSymbol);
        }
        return this;
    }

    public MethodCustomization getMethod(String methodNameOrSignature) {
        String methodName;
        String methodSignature = null;
        if (methodNameOrSignature.contains("(")) {
            methodSignature = BLOCK_OPEN.matcher(methodNameOrSignature).replaceFirst("");
            methodSignature = PUBLIC_MODIFIER.matcher(methodSignature).replaceFirst("");
            methodSignature = PRIVATE_MODIFIER.matcher(methodSignature).replaceFirst("");
            String returnTypeAndMethodName = methodNameOrSignature.split("\\(")[0];
            methodName = returnTypeAndMethodName.contains(" ") ? Utils.ANYTHING_THEN_SPACE_PATTERN.matcher(returnTypeAndMethodName).replaceAll("") : returnTypeAndMethodName;
        } else {
            methodName = methodNameOrSignature;
        }
        Optional<SymbolInformation> methodSymbol = this.languageClient.listDocumentSymbols(this.fileUri).stream().filter(si -> MEMBER_PARAMS.matcher(si.getName()).replaceFirst("").equals(methodName) && si.getKind() == SymbolKind.METHOD).filter(si -> this.editor.getFileLine(this.fileName, si.getLocation().getRange().getStart().getLine()).contains(methodNameOrSignature)).findFirst();
        if (!methodSymbol.isPresent()) {
            throw new IllegalArgumentException("Method " + methodNameOrSignature + " does not exist in class " + this.className);
        }
        if (methodSignature == null) {
            methodSignature = this.editor.getFileLine(this.fileName, methodSymbol.get().getLocation().getRange().getStart().getLine());
            methodSignature = BLOCK_OPEN.matcher(methodSignature).replaceFirst("");
            methodSignature = PUBLIC_MODIFIER.matcher(methodSignature).replaceFirst("");
            methodSignature = PRIVATE_MODIFIER.matcher(methodSignature).replaceFirst("");
        }
        return new MethodCustomization(this.editor, this.languageClient, this.packageName, this.className, methodName, methodSignature, methodSymbol.get());
    }

    public ConstructorCustomization getConstructor(String constructorNameOrSignature) {
        String constructorName;
        String constructorSignature = null;
        if (constructorNameOrSignature.contains("(")) {
            constructorSignature = BLOCK_OPEN.matcher(constructorNameOrSignature).replaceFirst("");
            constructorSignature = PUBLIC_MODIFIER.matcher(constructorSignature).replaceFirst("");
            constructorSignature = PRIVATE_MODIFIER.matcher(constructorSignature).replaceFirst("");
            String returnTypeAndMethodName = constructorNameOrSignature.split("\\(")[0];
            constructorName = returnTypeAndMethodName.contains(" ") ? Utils.ANYTHING_THEN_SPACE_PATTERN.matcher(returnTypeAndMethodName).replaceAll("") : returnTypeAndMethodName;
        } else {
            constructorName = constructorNameOrSignature;
        }
        List constructorSymbol = this.languageClient.listDocumentSymbols(this.fileUri).stream().filter(si -> MEMBER_PARAMS.matcher(si.getName()).replaceFirst("").equals(constructorName) && si.getKind() == SymbolKind.CONSTRUCTOR).filter(si -> this.editor.getFileLine(this.fileName, si.getLocation().getRange().getStart().getLine()).contains(constructorNameOrSignature)).collect(Collectors.toList());
        if (constructorSymbol.size() > 1) {
            throw new IllegalStateException("Multiple instances of " + constructorNameOrSignature + " exist in the class. Use a more specific constructor signature.");
        }
        if (constructorSymbol.size() == 0) {
            throw new IllegalArgumentException("Constructor " + constructorNameOrSignature + " does not exist in class " + this.className);
        }
        if (constructorSignature == null) {
            constructorSignature = this.editor.getFileLine(this.fileName, ((SymbolInformation)constructorSymbol.get(0)).getLocation().getRange().getStart().getLine());
            constructorSignature = BLOCK_OPEN.matcher(constructorSignature).replaceFirst("");
            constructorSignature = PUBLIC_MODIFIER.matcher(constructorSignature).replaceFirst("");
            constructorSignature = PRIVATE_MODIFIER.matcher(constructorSignature).replaceFirst("");
        }
        return new ConstructorCustomization(this.editor, this.languageClient, this.packageName, this.className, constructorSignature, (SymbolInformation)constructorSymbol.get(0));
    }

    public PropertyCustomization getProperty(String propertyName) {
        Optional<SymbolInformation> propertySymbol = this.languageClient.listDocumentSymbols(this.fileUri).stream().filter(si -> si.getName().equals(propertyName) && si.getKind() == SymbolKind.FIELD).findFirst();
        if (!propertySymbol.isPresent()) {
            throw new IllegalArgumentException("Property " + propertyName + " does not exist in class " + this.className);
        }
        return new PropertyCustomization(this.editor, this.languageClient, this.packageName, this.className, propertySymbol.get(), propertyName);
    }

    public ConstantCustomization getConstant(String constantName) {
        Optional<SymbolInformation> propertySymbol = this.languageClient.listDocumentSymbols(this.fileUri).stream().filter(si -> si.getName().equals(constantName) && si.getKind() == SymbolKind.CONSTANT).findFirst();
        if (!propertySymbol.isPresent()) {
            throw new IllegalArgumentException("Constant " + constantName + " does not exist in class " + this.className);
        }
        return new ConstantCustomization(this.editor, this.languageClient, this.packageName, this.className, propertySymbol.get(), constantName);
    }

    public JavadocCustomization getJavadoc() {
        return new JavadocCustomization(this.editor, this.languageClient, this.fileUri, this.fileName, this.symbol.getLocation().getRange().getStart().getLine());
    }

    public ConstructorCustomization addConstructor(String constructor) {
        return this.addConstructor(constructor, null);
    }

    public ConstructorCustomization addConstructor(String constructor, List<String> importsToAdd) {
        int constructorStartLine;
        List constructorLocationFinder;
        Matcher constructorSignatureMatcher = CONSTRUCTOR_SIGNATURE_PATTERN.matcher(constructor);
        String constructorSignature = null;
        if (constructorSignatureMatcher.find()) {
            constructorSignature = constructorSignatureMatcher.group(1);
        }
        if (Utils.isNullOrEmpty(constructorLocationFinder = this.languageClient.listDocumentSymbols(this.fileUri).stream().filter(symbol -> symbol.getKind() == SymbolKind.FIELD || symbol.getKind() == SymbolKind.CONSTRUCTOR).collect(Collectors.toList()))) {
            constructorStartLine = this.symbol.getLocation().getRange().getStart().getLine();
        } else {
            SymbolInformation symbol2 = (SymbolInformation)constructorLocationFinder.get(constructorLocationFinder.size() - 1);
            if (symbol2.getKind() == SymbolKind.FIELD) {
                constructorStartLine = symbol2.getLocation().getRange().getStart().getLine();
            } else {
                constructorStartLine = symbol2.getLocation().getRange().getStart().getLine();
                List<String> fileLines = this.editor.getFileLines(this.fileName);
                String currentLine = fileLines.get(constructorStartLine);
                String constructorIdent = Utils.getIndent(currentLine);
                while (!currentLine.endsWith("}") || !currentLine.equals(constructorIdent + "}")) {
                    currentLine = fileLines.get(++constructorStartLine);
                }
            }
        }
        int indentAmount = Utils.getIndent(this.editor.getFileLine(this.fileName, constructorStartLine)).length();
        this.editor.insertBlankLine(this.fileName, ++constructorStartLine, false);
        Position constructorPosition = this.editor.insertBlankLineWithIndent(this.fileName, ++constructorStartLine, indentAmount);
        this.editor.replaceWithIndentedContent(this.fileName, constructorPosition, constructorPosition, constructor, constructorPosition.getCharacter());
        String ctorSignature = constructorSignature == null ? this.editor.getFileLine(this.fileName, constructorStartLine) : constructorSignature;
        return Utils.addImports(importsToAdd, this, () -> this.getConstructor(ctorSignature));
    }

    public MethodCustomization addMethod(String method) {
        return this.addMethod(method, null);
    }

    public MethodCustomization addMethod(String method, List<String> importsToAdd) {
        Matcher methodSignatureMatcher = METHOD_SIGNATURE_PATTERN.matcher(method);
        String methodSignature = null;
        if (methodSignatureMatcher.find()) {
            methodSignature = methodSignatureMatcher.group(1);
        }
        List<String> fileLines = this.editor.getFileLines(this.fileName);
        int lineNum = fileLines.size();
        String currentLine = fileLines.get(--lineNum);
        while (!currentLine.endsWith("}") || currentLine.startsWith("}")) {
            currentLine = fileLines.get(--lineNum);
        }
        int indentAmount = Utils.getIndent(currentLine).length();
        this.editor.insertBlankLine(this.fileName, ++lineNum, false);
        Position newMethod = this.editor.insertBlankLineWithIndent(this.fileName, ++lineNum, indentAmount);
        this.editor.replaceWithIndentedContent(this.fileName, newMethod, newMethod, method, newMethod.getCharacter());
        String mSig = methodSignature == null ? this.editor.getFileLine(this.fileName, lineNum) : methodSignature;
        return Utils.addImports(importsToAdd, this, () -> this.getMethod(mSig));
    }

    public ClassCustomization removeMethod(String methodNameOrSignature) {
        MethodCustomization methodCustomization = this.getMethod(methodNameOrSignature);
        int methodSignatureLine = methodCustomization.getSymbol().getLocation().getRange().getStart().getLine();
        Position start = methodCustomization.getJavadoc().getJavadocRange().getStart();
        String bodyPositionFinder = this.editor.getFileLine(this.fileName, methodSignatureLine);
        String methodBlockIndent = Utils.getIndent(bodyPositionFinder);
        int endLine = Utils.walkDownFileUntilLineMatches(this.editor, this.fileName, methodSignatureLine, lineContent -> lineContent.matches(methodBlockIndent + "."));
        Position end = new Position(endLine, this.editor.getFileLine(this.fileName, endLine).length());
        this.editor.replace(this.fileName, start, end, "");
        FileEvent fileEvent = new FileEvent();
        fileEvent.setUri(this.fileUri);
        fileEvent.setType(FileChangeType.CHANGED);
        this.languageClient.notifyWatchedFilesChanged(Collections.singletonList(fileEvent));
        return this;
    }

    public ClassCustomization rename(String newName) {
        WorkspaceEdit workspaceEdit = this.languageClient.renameSymbol(this.fileUri, this.symbol.getLocation().getRange().getStart(), newName);
        ArrayList<FileEvent> changes = new ArrayList<FileEvent>();
        for (Map.Entry<URI, List<TextEdit>> edit : workspaceEdit.getChanges().entrySet()) {
            int i = edit.getKey().toString().indexOf("src/main/java/");
            String oldEntry = edit.getKey().toString().substring(i);
            if (!this.editor.getContents().containsKey(oldEntry)) continue;
            for (TextEdit textEdit : edit.getValue()) {
                this.editor.replace(oldEntry, textEdit.getRange().getStart(), textEdit.getRange().getEnd(), textEdit.getNewText());
            }
            FileEvent fileEvent = new FileEvent();
            fileEvent.setUri(edit.getKey());
            if (oldEntry.endsWith("/" + this.className + ".java")) {
                String newEntry = oldEntry.replace(this.className + ".java", newName + ".java");
                this.editor.renameFile(oldEntry, newEntry);
                URI newUri = URI.create(edit.getKey().toString().replace(this.className + ".java", newName + ".java"));
                fileEvent.setType(FileChangeType.DELETED);
                changes.add(fileEvent);
                FileEvent newFile = new FileEvent();
                newFile.setUri(newUri);
                newFile.setType(FileChangeType.CREATED);
                changes.add(newFile);
                continue;
            }
            fileEvent.setType(FileChangeType.CHANGED);
            changes.add(fileEvent);
        }
        this.languageClient.notifyWatchedFilesChanged(changes);
        String packagePath = this.packageName.replace(".", "/");
        Optional<SymbolInformation> newClassSymbol = this.languageClient.findWorkspaceSymbol(newName).stream().filter(si -> si.getLocation().getUri().toString().endsWith(packagePath + "/" + newName + ".java")).findFirst();
        if (!newClassSymbol.isPresent()) {
            throw new IllegalArgumentException("Renamed failed with new class " + newName + " not found.");
        }
        return new ClassCustomization(this.editor, this.languageClient, this.packageName, newName, newClassSymbol.get());
    }

    public ClassCustomization setModifier(int modifiers) {
        this.languageClient.listDocumentSymbols(this.symbol.getLocation().getUri()).stream().filter(si -> si.getName().equals(this.className) && si.getKind() == SymbolKind.CLASS).findFirst().ifPresent(symbolInformation -> Utils.replaceModifier(symbolInformation, this.editor, this.languageClient, "(?:.+ )?class " + this.className, "class " + this.className, Modifier.classModifiers(), modifiers));
        return this.refreshSymbol();
    }

    public ClassCustomization addAnnotation(String annotation) {
        Optional<SymbolInformation> symbol;
        if (!((String)annotation).startsWith("@")) {
            annotation = "@" + (String)annotation;
        }
        if ((symbol = this.languageClient.listDocumentSymbols(this.fileUri).stream().filter(si -> si.getKind() == SymbolKind.CLASS).findFirst()).isPresent() && this.editor.getContents().containsKey(this.fileName)) {
            int line = symbol.get().getLocation().getRange().getStart().getLine();
            Position position = this.editor.insertBlankLine(this.fileName, line, true);
            this.editor.replace(this.fileName, position, position, (String)annotation);
            FileEvent fileEvent = new FileEvent();
            fileEvent.setUri(this.fileUri);
            fileEvent.setType(FileChangeType.CHANGED);
            this.languageClient.notifyWatchedFilesChanged(Collections.singletonList(fileEvent));
            Utils.organizeImportsOnRange(this.languageClient, this.editor, this.fileUri, symbol.get().getLocation().getRange());
        }
        return this.refreshSymbol();
    }

    public ClassCustomization removeAnnotation(String annotation) {
        return Utils.removeAnnotation(this, compilationUnit -> ((ClassOrInterfaceDeclaration)compilationUnit.getClassByName(this.className).get()).getAnnotationByName(Utils.cleanAnnotationName(annotation)), this::refreshSymbol);
    }

    public ClassCustomization renameEnumMember(String enumMemberName, String newName) {
        URI fileUri = this.symbol.getLocation().getUri();
        this.languageClient.listDocumentSymbols(fileUri).stream().filter(si -> si.getName().toLowerCase().contains(enumMemberName.toLowerCase())).forEach(symbol -> {
            WorkspaceEdit edit = this.languageClient.renameSymbol(fileUri, symbol.getLocation().getRange().getStart(), newName);
            Utils.applyWorkspaceEdit(edit, this.editor, this.languageClient);
        });
        return this;
    }

    public ClassCustomization customizeAst(Consumer<CompilationUnit> astCustomization) {
        CompilationUnit astToEdit = StaticJavaParser.parse((String)this.editor.getFileContent(this.fileName));
        astCustomization.accept(astToEdit);
        this.editor.replaceFile(this.fileName, astToEdit.toString());
        FileEvent fileEvent = new FileEvent();
        fileEvent.setUri(this.fileUri);
        fileEvent.setType(FileChangeType.CHANGED);
        this.languageClient.notifyWatchedFilesChanged(Collections.singletonList(fileEvent));
        return this.refreshSymbol();
    }

    ClassCustomization refreshSymbol() {
        return new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className);
    }
}

