/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import java.net.URI;

public abstract class CodeCustomization {
    final Editor editor;
    final EclipseLanguageClient languageClient;
    final SymbolInformation symbol;
    final URI fileUri;
    final String fileName;

    CodeCustomization(Editor editor, EclipseLanguageClient languageClient, SymbolInformation symbol) {
        this.editor = editor;
        this.languageClient = languageClient;
        this.symbol = symbol;
        this.fileUri = symbol.getLocation().getUri();
        int i = this.fileUri.toString().indexOf("src/main/java/");
        this.fileName = this.fileUri.toString().substring(i);
    }

    public final Editor getEditor() {
        return this.editor;
    }

    public final EclipseLanguageClient getLanguageClient() {
        return this.languageClient;
    }

    public final SymbolInformation getSymbol() {
        return this.symbol;
    }

    public final URI getFileUri() {
        return this.fileUri;
    }

    public final String getFileName() {
        return this.fileName;
    }
}

