/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.CodeCustomization;
import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.JavadocCustomization;
import com.azure.autorest.customization.PackageCustomization;
import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import com.azure.autorest.customization.implementation.ls.models.SymbolKind;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceEdit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.regex.Pattern;

public final class ConstantCustomization
extends CodeCustomization {
    private static final Pattern METHOD_PARAMS_CAPTURE = Pattern.compile("\\(.*\\)");
    private final String packageName;
    private final String className;
    private final String constantName;

    ConstantCustomization(Editor editor, EclipseLanguageClient languageClient, String packageName, String className, SymbolInformation symbol, String constantName) {
        super(editor, languageClient, symbol);
        this.packageName = packageName;
        this.className = className;
        this.constantName = constantName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getConstantName() {
        return this.constantName;
    }

    public JavadocCustomization getJavadoc() {
        return new JavadocCustomization(this.editor, this.languageClient, this.fileUri, this.fileName, this.symbol.getLocation().getRange().getStart().getLine());
    }

    public ConstantCustomization setModifier(int modifiers) {
        Utils.replaceModifier(this.symbol, this.editor, this.languageClient, "(?:.+ )?(\\w+ )" + this.constantName + "\\(", "$1" + this.constantName + "(", Modifier.fieldModifiers(), 0x18 | modifiers);
        return this.refreshCustomization(this.constantName);
    }

    public ConstantCustomization rename(String newName) {
        Objects.requireNonNull(newName, "'newName' cannot be null.");
        String lowercaseConstantName = this.constantName.toLowerCase();
        String currentCamelName = ConstantCustomization.constantToMethodName(this.constantName);
        String lowercaseCurrentCamelName = currentCamelName.toLowerCase();
        String newCamelName = ConstantCustomization.constantToMethodName(newName);
        this.languageClient.listDocumentSymbols(this.fileUri).stream().filter(si -> {
            String symbolName = si.getName().toLowerCase();
            return symbolName.contains(lowercaseConstantName) || symbolName.contains(lowercaseCurrentCamelName);
        }).forEach(symbol -> {
            if (symbol.getKind() == SymbolKind.CONSTANT) {
                WorkspaceEdit edit = this.languageClient.renameSymbol(this.fileUri, symbol.getLocation().getRange().getStart(), newName);
                Utils.applyWorkspaceEdit(edit, this.editor, this.languageClient);
            } else if (symbol.getKind() == SymbolKind.METHOD) {
                String methodName = symbol.getName().replace(currentCamelName, newCamelName).replace(this.constantName, newName);
                methodName = METHOD_PARAMS_CAPTURE.matcher(methodName).replaceFirst("");
                WorkspaceEdit edit = this.languageClient.renameSymbol(this.fileUri, symbol.getLocation().getRange().getStart(), methodName);
                Utils.applyWorkspaceEdit(edit, this.editor, this.languageClient);
            }
        });
        return this.refreshCustomization(newName);
    }

    private static String constantToMethodName(String constantName) {
        StringBuilder camelBuilder = new StringBuilder(constantName.length());
        for (String word : constantName.split("_")) {
            if (word.length() == 0) continue;
            camelBuilder.append(word.charAt(0));
            if (word.length() <= 1) continue;
            camelBuilder.append(word.substring(1).toLowerCase());
        }
        return camelBuilder.toString();
    }

    public ConstantCustomization addAnnotation(String annotation) {
        return Utils.addAnnotation(annotation, this, () -> this.refreshCustomization(this.constantName));
    }

    public ConstantCustomization removeAnnotation(String annotation) {
        return Utils.removeAnnotation(this, compilationUnit -> ((FieldDeclaration)((ClassOrInterfaceDeclaration)compilationUnit.getClassByName(this.className).get()).getFieldByName(this.constantName).get()).getAnnotationByName(Utils.cleanAnnotationName(annotation)), () -> this.refreshCustomization(this.constantName));
    }

    private ConstantCustomization refreshCustomization(String constantName) {
        return new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className).getConstant(constantName);
    }
}

