/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.ClassCustomization;
import com.azure.autorest.customization.CodeCustomization;
import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.JavadocCustomization;
import com.azure.autorest.customization.PackageCustomization;
import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.FileChangeType;
import com.azure.autorest.customization.implementation.ls.models.FileEvent;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import com.azure.autorest.customization.implementation.ls.models.TextEdit;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceEdit;
import com.azure.autorest.customization.models.Position;
import com.azure.autorest.customization.models.Range;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MethodCustomization
extends CodeCustomization {
    private final String packageName;
    private final String className;
    private final String methodName;
    private final String methodSignature;

    MethodCustomization(Editor editor, EclipseLanguageClient languageClient, String packageName, String className, String methodName, String methodSignature, SymbolInformation symbol) {
        super(editor, languageClient, symbol);
        this.packageName = packageName;
        this.className = className;
        this.methodName = methodName;
        this.methodSignature = methodSignature;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public JavadocCustomization getJavadoc() {
        return new JavadocCustomization(this.editor, this.languageClient, this.fileUri, this.fileName, this.symbol.getLocation().getRange().getStart().getLine());
    }

    public MethodCustomization rename(String newName) {
        WorkspaceEdit edit = this.languageClient.renameSymbol(this.fileUri, this.symbol.getLocation().getRange().getStart(), newName);
        Utils.applyWorkspaceEdit(edit, this.editor, this.languageClient);
        return this.refreshCustomization(this.methodSignature.replace(this.methodName + "(", newName + "("));
    }

    public MethodCustomization addAnnotation(String annotation) {
        return Utils.addAnnotation(annotation, this, () -> this.refreshCustomization(this.methodSignature));
    }

    public MethodCustomization removeAnnotation(String annotation) {
        return Utils.removeAnnotation(this, compilationUnit -> ((ClassOrInterfaceDeclaration)compilationUnit.getClassByName(this.className).get()).getMethodsByName(this.methodName).stream().filter(method -> Utils.declarationContainsSymbol((com.github.javaparser.Range)method.getRange().get(), this.symbol.getLocation().getRange())).findFirst().get().getAnnotationByName(Utils.cleanAnnotationName(annotation)), () -> this.refreshCustomization(this.methodSignature));
    }

    public MethodCustomization setModifier(int modifiers) {
        Utils.replaceModifier(this.symbol, this.editor, this.languageClient, "(?:.+ )?(\\w+ )" + this.methodName + "\\(", "$1" + this.methodName + "(", Modifier.methodModifiers(), modifiers);
        return this.refreshCustomization(this.methodSignature);
    }

    public MethodCustomization replaceParameters(String newParameters) {
        return this.replaceParameters(newParameters, null);
    }

    public MethodCustomization replaceParameters(String newParameters, List<String> importsToAdd) {
        String newSignature = this.methodName + "(" + newParameters + ")";
        ClassCustomization classCustomization = new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className);
        ClassCustomization updatedClassCustomization = Utils.addImports(importsToAdd, classCustomization, classCustomization::refreshSymbol);
        return Utils.replaceParameters(newParameters, updatedClassCustomization.getMethod(this.methodSignature), () -> updatedClassCustomization.getMethod(newSignature));
    }

    public MethodCustomization replaceBody(String newBody) {
        return this.replaceBody(newBody, null);
    }

    public MethodCustomization replaceBody(String newBody, List<String> importsToAdd) {
        ClassCustomization classCustomization = new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className);
        ClassCustomization updatedClassCustomization = Utils.addImports(importsToAdd, classCustomization, classCustomization::refreshSymbol);
        return Utils.replaceBody(newBody, updatedClassCustomization.getMethod(this.methodSignature), () -> updatedClassCustomization.getMethod(this.methodSignature));
    }

    public MethodCustomization setReturnType(String newReturnType, String returnValueFormatter) {
        return this.setReturnType(newReturnType, returnValueFormatter, false);
    }

    public MethodCustomization setReturnType(String newReturnType, String returnValueFormatter, boolean replaceReturnStatement) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        int line = this.symbol.getLocation().getRange().getStart().getLine();
        Position start = new Position(line, 0);
        String oldLineContent = this.editor.getFileLine(this.fileName, line);
        Position end = new Position(line, oldLineContent.length());
        String newLineContent = oldLineContent.replaceFirst("(\\w.* )?(\\w+) " + this.methodName + "\\(", "$1" + newReturnType + " " + this.methodName + "(");
        TextEdit signatureEdit = new TextEdit();
        signatureEdit.setNewText(newLineContent);
        signatureEdit.setRange(new Range(start, end));
        edits.add(signatureEdit);
        String methodIndent = Utils.getIndent(this.editor.getFileLine(this.fileName, line));
        String methodContentIndent = Utils.getIndent(this.editor.getFileLine(this.fileName, line + 1));
        String oldReturnType = oldLineContent.replaceAll(" " + this.methodName + "\\(.*", "").replaceFirst(methodIndent + "(\\w.* )?", "").trim();
        int returnLine = -1;
        while (!oldLineContent.startsWith(methodIndent + "}")) {
            if (oldLineContent.contains("return ")) {
                returnLine = line;
            }
            oldLineContent = this.editor.getFileLine(this.fileName, ++line);
        }
        if (returnLine == -1) {
            this.editor.insertBlankLine(this.fileName, line, false);
            FileEvent blankLineEvent = new FileEvent();
            blankLineEvent.setUri(this.fileUri);
            blankLineEvent.setType(FileChangeType.CHANGED);
            this.languageClient.notifyWatchedFilesChanged(Collections.singletonList(blankLineEvent));
            TextEdit returnEdit = new TextEdit();
            returnEdit.setRange(new Range(new Position(line, 0), new Position(line, 0)));
            returnEdit.setNewText(methodContentIndent + "return " + returnValueFormatter + ";");
            edits.add(returnEdit);
        } else if (newReturnType.equals("void")) {
            TextEdit returnEdit = new TextEdit();
            returnEdit.setNewText("");
            returnEdit.setRange(new Range(new Position(returnLine, 0), new Position(line, 0)));
            edits.add(returnEdit);
        } else {
            TextEdit returnValueEdit = new TextEdit();
            String returnLineText = this.editor.getFileLine(this.fileName, returnLine);
            returnValueEdit.setRange(new Range(new Position(returnLine, 0), new Position(returnLine, returnLineText.length())));
            returnValueEdit.setNewText(returnLineText.replace("return ", oldReturnType + " returnValue = "));
            edits.add(returnValueEdit);
            this.editor.insertBlankLine(this.fileName, line, false);
            FileEvent blankLineEvent = new FileEvent();
            blankLineEvent.setUri(this.fileUri);
            blankLineEvent.setType(FileChangeType.CHANGED);
            this.languageClient.notifyWatchedFilesChanged(Collections.singletonList(blankLineEvent));
            TextEdit returnEdit = new TextEdit();
            returnEdit.setRange(new Range(new Position(line, 0), new Position(line, 0)));
            if (replaceReturnStatement) {
                returnEdit.setNewText(String.format(returnValueFormatter, "returnValue"));
            } else {
                returnEdit.setNewText(methodContentIndent + "return " + String.format(returnValueFormatter, "returnValue") + ";");
            }
            edits.add(returnEdit);
        }
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        workspaceEdit.setChanges(Collections.singletonMap(this.fileUri, edits));
        Utils.applyWorkspaceEdit(workspaceEdit, this.editor, this.languageClient);
        Utils.organizeImportsOnRange(this.languageClient, this.editor, this.fileUri, new Range(start, end));
        String newMethodSignature = this.methodSignature.replace(oldReturnType + " " + this.methodName, newReturnType + " " + this.methodName);
        return this.refreshCustomization(newMethodSignature);
    }

    private MethodCustomization refreshCustomization(String methodSignature) {
        return new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className).getMethod(methodSignature);
    }
}

