/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization.implementation.ls;

import com.azure.autorest.customization.implementation.ls.BuildWorkspaceStatus;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageServerFacade;
import com.azure.autorest.customization.implementation.ls.models.ClientCapabilities;
import com.azure.autorest.customization.implementation.ls.models.CodeAction;
import com.azure.autorest.customization.implementation.ls.models.CodeActionClientCapabilities;
import com.azure.autorest.customization.implementation.ls.models.CodeActionKind;
import com.azure.autorest.customization.implementation.ls.models.CodeActionKindValueSet;
import com.azure.autorest.customization.implementation.ls.models.CodeActionLiteralSupport;
import com.azure.autorest.customization.implementation.ls.models.DidChangeTextDocumentParams;
import com.azure.autorest.customization.implementation.ls.models.DidChangeWatchedFilesParams;
import com.azure.autorest.customization.implementation.ls.models.DidCloseTextDocumentParams;
import com.azure.autorest.customization.implementation.ls.models.DidOpenTextDocumentParams;
import com.azure.autorest.customization.implementation.ls.models.DidSaveTextDocumentParams;
import com.azure.autorest.customization.implementation.ls.models.DocumentFormattingParams;
import com.azure.autorest.customization.implementation.ls.models.DocumentSymbolParams;
import com.azure.autorest.customization.implementation.ls.models.FileEvent;
import com.azure.autorest.customization.implementation.ls.models.FormattingOptions;
import com.azure.autorest.customization.implementation.ls.models.InitializeParams;
import com.azure.autorest.customization.implementation.ls.models.InitializeResponse;
import com.azure.autorest.customization.implementation.ls.models.JavaCodeActionKind;
import com.azure.autorest.customization.implementation.ls.models.RenameParams;
import com.azure.autorest.customization.implementation.ls.models.ServerCapabilities;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import com.azure.autorest.customization.implementation.ls.models.SymbolKind;
import com.azure.autorest.customization.implementation.ls.models.SymbolKindCapabilities;
import com.azure.autorest.customization.implementation.ls.models.TextDocumentClientCapabilities;
import com.azure.autorest.customization.implementation.ls.models.TextDocumentContentChangeEvent;
import com.azure.autorest.customization.implementation.ls.models.TextDocumentIdentifier;
import com.azure.autorest.customization.implementation.ls.models.TextDocumentItem;
import com.azure.autorest.customization.implementation.ls.models.TextEdit;
import com.azure.autorest.customization.implementation.ls.models.VersionedTextDocumentIdentifier;
import com.azure.autorest.customization.implementation.ls.models.WillSaveTextDocumentParams;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceCapabilities;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceEdit;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceFolder;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceSymbolClientCapabilities;
import com.azure.autorest.customization.models.Position;
import com.azure.autorest.customization.models.Range;
import com.azure.autorest.extension.base.jsonrpc.Connection;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class EclipseLanguageClient
implements AutoCloseable {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final EclipseLanguageServerFacade server;
    private final Connection connection;
    private final ServerSocket serverSocket;
    private final AtomicReference<Socket> clientSocket = new AtomicReference();
    private final URI workspaceDir;
    private ServerCapabilities serverCapabilities;

    public EclipseLanguageClient(String workspaceDir) {
        this(null, workspaceDir);
    }

    public EclipseLanguageClient(String pathToLanguageServerPlugin, String workspaceDir) {
        this.workspaceDir = new File(workspaceDir).toURI();
        try {
            this.serverSocket = new ServerSocket(0);
            int port = this.serverSocket.getLocalPort();
            Thread thread = new Thread(() -> {
                try {
                    this.clientSocket.set(this.serverSocket.accept());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            thread.start();
            Thread.sleep(1000L);
            this.server = pathToLanguageServerPlugin == null ? new EclipseLanguageServerFacade(port) : new EclipseLanguageServerFacade(pathToLanguageServerPlugin, port);
            thread.join(10000L);
            if (this.clientSocket.get() == null) {
                throw new IllegalStateException("EclipseLanguageServer failed to start on CLIENT_PORT " + port + ". Make sure you have stopped any previous EclipseLanguageServer. If not sure, you may kill all 'java' process.");
            }
            this.connection = new Connection(this.clientSocket.get().getOutputStream(), this.clientSocket.get().getInputStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize() {
        int pid = (int)ProcessHandle.current().pid();
        InitializeParams initializeParams = new InitializeParams();
        initializeParams.setProcessId(pid);
        initializeParams.setRootUri(this.workspaceDir);
        initializeParams.setWorkspaceFolders(new ArrayList<WorkspaceFolder>());
        WorkspaceFolder workspaceFolder = new WorkspaceFolder();
        workspaceFolder.setName("root");
        workspaceFolder.setUri(this.workspaceDir);
        initializeParams.getWorkspaceFolders().add(workspaceFolder);
        initializeParams.setTrace("message");
        initializeParams.setCapabilities(new ClientCapabilities());
        initializeParams.getCapabilities().setWorkspace(new WorkspaceCapabilities());
        initializeParams.getCapabilities().getWorkspace().setSymbol(new WorkspaceSymbolClientCapabilities());
        initializeParams.getCapabilities().getWorkspace().getSymbol().setSymbolKind(new SymbolKindCapabilities());
        initializeParams.getCapabilities().getWorkspace().getSymbol().getSymbolKind().setValueSet(Arrays.asList(SymbolKind.values()));
        initializeParams.getCapabilities().getWorkspace().getSymbol().setDynamicRegistration(false);
        initializeParams.getCapabilities().getWorkspace().setWorkspaceFolders(true);
        initializeParams.getCapabilities().setTextDocument(new TextDocumentClientCapabilities());
        initializeParams.getCapabilities().getTextDocument().setCodeAction(new CodeActionClientCapabilities());
        initializeParams.getCapabilities().getTextDocument().getCodeAction().setCodeActionLiteralSupport(new CodeActionLiteralSupport());
        initializeParams.getCapabilities().getTextDocument().getCodeAction().getCodeActionLiteralSupport().setCodeActionKind(new CodeActionKindValueSet());
        initializeParams.getCapabilities().getTextDocument().getCodeAction().getCodeActionLiteralSupport().getCodeActionKind().setValueSet(new ArrayList<String>());
        for (CodeActionKind codeActionKind : CodeActionKind.values()) {
            initializeParams.getCapabilities().getTextDocument().getCodeAction().getCodeActionLiteralSupport().getCodeActionKind().getValueSet().add(codeActionKind.toString());
        }
        for (Enum enum_ : JavaCodeActionKind.values()) {
            initializeParams.getCapabilities().getTextDocument().getCodeAction().getCodeActionLiteralSupport().getCodeActionKind().getValueSet().add(((JavaCodeActionKind)enum_).toString());
        }
        InitializeResponse response = (InitializeResponse)this.connection.requestWithObject(OBJECT_MAPPER.constructType(InitializeResponse.class), "initialize", (Object)initializeParams);
        this.serverCapabilities = response.getCapabilities();
        this.connection.notifyWithObject("initialized", null);
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public BuildWorkspaceStatus buildWorkspace(boolean forceRebuild) {
        return (BuildWorkspaceStatus)((Object)this.connection.requestWithObject(OBJECT_MAPPER.constructType(BuildWorkspaceStatus.class), "java/buildWorkspace", (Object)forceRebuild));
    }

    public List<TextEdit> format(URI fileUri) {
        if (this.serverCapabilities.getDocumentFormattingProvider()) {
            DocumentFormattingParams params = new DocumentFormattingParams();
            params.setTextDocument(new TextDocumentIdentifier(fileUri));
            params.setOptions(new FormattingOptions());
            params.getOptions().setTabSize(4);
            params.getOptions().setInsertSpaces(true);
            params.getOptions().setTrimTrailingWhitespace(true);
            return (List)this.connection.requestWithObject((JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionLikeType(List.class, TextEdit.class), "textDocument/formatting", (Object)params);
        }
        return Collections.emptyList();
    }

    public void notifyFileOpened(URI fileUri, String content, int version) {
        if (this.serverCapabilities.getTextDocumentSync() != null && this.serverCapabilities.getTextDocumentSync().isOpenClose()) {
            DidOpenTextDocumentParams params = new DidOpenTextDocumentParams();
            TextDocumentItem item = new TextDocumentItem();
            item.setUri(fileUri);
            item.setText(content);
            item.setVersion(version);
            params.setTextDocument(item);
            this.connection.notifyWithObject("textDocument/didOpen", (Object)params);
        }
    }

    public void notifyFileClosed(URI fileUri) {
        if (this.serverCapabilities.getTextDocumentSync() != null && this.serverCapabilities.getTextDocumentSync().isOpenClose()) {
            DidCloseTextDocumentParams params = new DidCloseTextDocumentParams();
            TextDocumentIdentifier item = new TextDocumentIdentifier(fileUri);
            params.setTextDocument(item);
            this.connection.notifyWithObject("textDocument/didClose", (Object)params);
        }
    }

    public void notifyFileChanged(URI fileUri, String newContent, List<TextEdit> textEdits, int version) {
        if (this.serverCapabilities.getTextDocumentSync() != null && this.serverCapabilities.getTextDocumentSync().getChange() != 0) {
            DidChangeTextDocumentParams params = new DidChangeTextDocumentParams();
            VersionedTextDocumentIdentifier item = new VersionedTextDocumentIdentifier(fileUri);
            item.setVersion(version);
            params.setTextDocument(item);
            ArrayList<TextDocumentContentChangeEvent> changeEvents = new ArrayList<TextDocumentContentChangeEvent>();
            for (TextEdit textEdit : textEdits) {
                TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
                if (this.serverCapabilities.getTextDocumentSync().getChange() == 1) {
                    changeEvent.setText(newContent);
                } else if (this.serverCapabilities.getTextDocumentSync().getChange() == 2) {
                    changeEvent.setRange(textEdit.getRange());
                    changeEvent.setText(textEdit.getNewText());
                }
                changeEvents.add(changeEvent);
            }
            params.setContentChanges(changeEvents);
            this.connection.notifyWithObject("textDocument/didChange", (Object)params);
        }
    }

    public void notifyWatchedFilesChanged(List<FileEvent> changes) {
        DidChangeWatchedFilesParams params = new DidChangeWatchedFilesParams();
        params.setChanges(changes);
        this.connection.notifyWithObject("workspace/didChangeWatchedFiles", (Object)params);
    }

    public void notifyFileToSave(URI fileUri) {
        if (this.serverCapabilities.getTextDocumentSync() != null && this.serverCapabilities.getTextDocumentSync().isWillSave()) {
            WillSaveTextDocumentParams params = new WillSaveTextDocumentParams();
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(fileUri);
            params.setTextDocument(identifier);
            this.connection.notifyWithObject("textDocument/willSave", (Object)params);
        }
    }

    public void notifyFileSaved(URI fileUri, String content) {
        if (this.serverCapabilities.getTextDocumentSync() != null && this.serverCapabilities.getTextDocumentSync().getSave() != null) {
            DidSaveTextDocumentParams params = new DidSaveTextDocumentParams();
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(fileUri);
            params.setTextDocument(identifier);
            if (this.serverCapabilities.getTextDocumentSync().getSave().isIncludeText()) {
                params.setText(content);
            }
            this.connection.notifyWithObject("textDocument/didSave", (Object)params);
        }
    }

    public List<SymbolInformation> findWorkspaceSymbol(String query) {
        HashMap<String, String> workspaceSymbolParams = new HashMap<String, String>();
        workspaceSymbolParams.put("query", query);
        return (List)this.connection.requestWithObject((JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionLikeType(List.class, SymbolInformation.class), "workspace/symbol", workspaceSymbolParams);
    }

    public List<SymbolInformation> listDocumentSymbols(URI fileUri) {
        DocumentSymbolParams documentSymbolParams = new DocumentSymbolParams();
        documentSymbolParams.setTextDocument(new TextDocumentIdentifier(fileUri));
        return (List)this.connection.requestWithObject((JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionLikeType(List.class, SymbolInformation.class), "textDocument/documentSymbol", (Object)documentSymbolParams);
    }

    public WorkspaceEdit renameSymbol(URI fileUri, Position symbolPosition, String newName) {
        RenameParams renameParams = new RenameParams();
        renameParams.setTextDocument(new TextDocumentIdentifier(fileUri));
        renameParams.setPosition(symbolPosition);
        renameParams.setNewName(newName);
        return (WorkspaceEdit)this.connection.requestWithObject(OBJECT_MAPPER.constructType(WorkspaceEdit.class), "textDocument/rename", (Object)renameParams);
    }

    public List<CodeAction> listCodeActions(URI fileUri, Range range) {
        HashMap<String, Object> codeActionParams = new HashMap<String, Object>();
        codeActionParams.put("textDocument", new TextDocumentIdentifier(fileUri));
        codeActionParams.put("range", range);
        codeActionParams.put("context", Collections.singletonMap("diagnostics", new ArrayList()));
        return (List)this.connection.requestWithObject((JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionLikeType(List.class, CodeAction.class), "textDocument/codeAction", codeActionParams);
    }

    @Override
    public void close() {
        try {
            this.connection.notifyWithObject("exit", null);
            this.clientSocket.get().close();
            this.serverSocket.close();
            this.connection.stop();
            this.server.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

