/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization.implementation.ls.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CodeActionKind {
    QUICK_FIX("quickfix"),
    REFACTOR("refactor"),
    REFACTOR_EXTRACT("refactor.extract"),
    REFACTOR_INLINE("refactor.inline"),
    REFACTOR_REWRITE("refactor.rewrite"),
    SOURCE("source"),
    SOURCE_ORGANIZEIMPORTS("source.organizeImports");

    private static final Map<String, CodeActionKind> STRING_TO_KIND_MAP;
    private final String value;

    private CodeActionKind(String value) {
        this.value = value;
    }

    @JsonCreator
    public static CodeActionKind fromString(String value) {
        return STRING_TO_KIND_MAP.get(value);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    static {
        STRING_TO_KIND_MAP = new HashMap<String, CodeActionKind>();
        for (CodeActionKind kind : CodeActionKind.values()) {
            STRING_TO_KIND_MAP.putIfAbsent(kind.value, kind);
        }
    }
}

