/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization.implementation.ls.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum FileChangeType {
    CREATED(1),
    CHANGED(2),
    DELETED(3);

    private static final FileChangeType[] INT_TO_KIND_MAP;
    private final int value;
    private final String valueString;

    private FileChangeType(int value) {
        this.value = value;
        this.valueString = Integer.toString(value);
    }

    @JsonCreator
    public static FileChangeType fromInt(int value) {
        return value < 0 || value >= INT_TO_KIND_MAP.length ? null : INT_TO_KIND_MAP[value];
    }

    @JsonValue
    public String toString() {
        return this.valueString;
    }

    static {
        INT_TO_KIND_MAP = new FileChangeType[4];
        FileChangeType[] fileChangeTypeArray = FileChangeType.values();
        int n = fileChangeTypeArray.length;
        for (int i = 0; i < n; ++i) {
            FileChangeType kind;
            FileChangeType.INT_TO_KIND_MAP[kind.value] = kind = fileChangeTypeArray[i];
        }
    }
}

