/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.model.codemodel;

import com.azure.autorest.extension.base.model.codemodel.PrimitiveSchema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DurationSchema
extends PrimitiveSchema {
    private Format format;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DurationSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationSchema that = (DurationSchema)o;
        return this.format == that.format;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format});
    }

    public static enum Format {
        DURATION("duration-rfc3339"),
        SECONDS_INTEGER("seconds-integer"),
        SECONDS_NUMBER("seconds-number");

        private final String value;
        private static final Map<String, Format> CONSTANTS;

        private Format(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static Format fromValue(String value) {
            Format constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Format>();
            for (Format c : Format.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

