/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.model.codemodel;

import java.util.HashMap;
import java.util.Map;

public enum RequestParameterLocation {
    BODY("body"),
    COOKIE("cookie"),
    URI("uri"),
    PATH("path"),
    HEADER("header"),
    NONE("none"),
    QUERY("query");

    private final String value;
    private static final Map<String, RequestParameterLocation> CONSTANTS;

    public int getValue() {
        return this.ordinal();
    }

    private RequestParameterLocation(String value) {
        this.value = value;
    }

    public String toString() {
        if ("uri".equals(this.value)) {
            return "host";
        }
        return this.value;
    }

    public String value() {
        return this.value;
    }

    public static RequestParameterLocation fromValue(String value) {
        RequestParameterLocation constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, RequestParameterLocation>();
        for (RequestParameterLocation c : RequestParameterLocation.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

