/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.extension.base.plugin;

import com.azure.autorest.extension.base.model.MessageChannel;
import com.azure.autorest.extension.base.plugin.NewPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public final class PluginLogger
extends MarkerIgnoringBase {
    private final NewPlugin plugin;
    private final List<String> keys;
    private final boolean isTracingEnabled;
    private final boolean isDebugEnabled;

    public PluginLogger(NewPlugin plugin, Class<?> clazz, String ... labels) {
        this(plugin, (String[])Stream.concat(Stream.of(clazz.getSimpleName()), Stream.of(labels)).toArray(String[]::new));
    }

    public PluginLogger(NewPlugin plugin, String ... labels) {
        this.plugin = plugin;
        this.keys = labels == null || labels.length == 0 ? Collections.emptyList() : Arrays.asList(labels);
        this.isTracingEnabled = plugin.getBooleanValue("verbose", false);
        this.isDebugEnabled = plugin.getBooleanValue("debug", false) || plugin.getBooleanValue("debugger", false);
    }

    public String getName() {
        return String.join((CharSequence)"/", this.keys);
    }

    public boolean isTraceEnabled() {
        return this.isTracingEnabled;
    }

    public void trace(String msg) {
        this.logMessageWithFormat(MessageChannel.VERBOSE, msg, new Object[0]);
    }

    public void trace(String format, Object arg1) {
        this.logMessageWithFormat(MessageChannel.VERBOSE, format, arg1);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(MessageChannel.VERBOSE, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.logMessageWithFormat(MessageChannel.VERBOSE, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.log(MessageChannel.VERBOSE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void debug(String msg) {
        this.logMessageWithFormat(MessageChannel.DEBUG, msg, new Object[0]);
    }

    public void debug(String format, Object arg) {
        this.logMessageWithFormat(MessageChannel.DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(MessageChannel.DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object ... args) {
        this.logMessageWithFormat(MessageChannel.DEBUG, format, args);
    }

    public void debug(String msg, Throwable t) {
        this.log(MessageChannel.DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        this.logMessageWithFormat(MessageChannel.INFORMATION, msg, new Object[0]);
    }

    public void info(String format, Object arg) {
        this.logMessageWithFormat(MessageChannel.INFORMATION, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(MessageChannel.INFORMATION, format, arg1, arg2);
    }

    public void info(String format, Object ... args) {
        this.logMessageWithFormat(MessageChannel.INFORMATION, format, args);
    }

    public void info(String msg, Throwable t) {
        this.log(MessageChannel.INFORMATION, msg, t);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.logMessageWithFormat(MessageChannel.WARNING, msg, new Object[0]);
    }

    public void warn(String format, Object arg) {
        this.logMessageWithFormat(MessageChannel.WARNING, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(MessageChannel.WARNING, format, arg1, arg2);
    }

    public void warn(String format, Object ... args) {
        this.logMessageWithFormat(MessageChannel.WARNING, format, args);
    }

    public void warn(String msg, Throwable t) {
        this.log(MessageChannel.WARNING, msg, t);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String format, Object arg) {
        this.logMessageWithFormat(MessageChannel.ERROR, format, arg);
    }

    public void error(String msg) {
        this.logMessageWithFormat(MessageChannel.ERROR, msg, new Object[0]);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(MessageChannel.ERROR, format, arg1, arg2);
    }

    public void error(String format, Object ... args) {
        this.logMessageWithFormat(MessageChannel.ERROR, format, args);
    }

    public void error(String msg, Throwable t) {
        this.log(MessageChannel.ERROR, msg, t);
    }

    private void logMessageWithFormat(MessageChannel messageChannel, String format, Object ... arguments) {
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.log(messageChannel, tp.getMessage(), tp.getThrowable());
    }

    private void log(MessageChannel messageChannel, String message, Throwable t) {
        this.plugin.message(messageChannel, message, t, this.keys);
    }
}

