/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.util;

import com.barchart.udt.EpollUDT;
import com.barchart.udt.util.UngrowableSet;
import com.barchart.udt.util.UnmodifiableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpUDT {
    protected static final Logger log = LoggerFactory.getLogger(EpollUDT.class);

    public static long md5sum(String text) {
        byte[] defaultBytes = text.getBytes();
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(defaultBytes);
            byte[] digest = algorithm.digest();
            ByteBuffer buffer = ByteBuffer.wrap(digest);
            return buffer.getLong();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("md5 failed", (Throwable)e);
            return 0L;
        }
    }

    public static final IntBuffer newDirectIntBufer(int capacity) {
        return ByteBuffer.allocateDirect(capacity * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static <E> Set<E> ungrowableSet(Set<E> set) {
        return new UngrowableSet<E>(set);
    }

    public static <E> Set<E> unmodifiableSet(Collection<E> values) {
        return new UnmodifiableSet<E>(values);
    }

    private HelpUDT() {
    }

    public static final void checkBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer == null");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("must use DirectByteBuffer");
        }
    }

    public static final void checkArray(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("array == null");
        }
    }

    public static String constantFieldName(Class<?> klaz, Object instance) {
        Field[] filedArray;
        for (Field field : filedArray = klaz.getDeclaredFields()) {
            boolean isConstant;
            int modifiers = field.getModifiers();
            boolean bl = isConstant = Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
            if (!isConstant) continue;
            try {
                if (instance != field.get(null)) continue;
                return field.getName();
            }
            catch (Throwable e) {
                log.debug("", e);
            }
        }
        return "unknown";
    }

    public static void checkSocketAddress(InetSocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new IllegalArgumentException("socketAddress can't be null");
        }
        if (socketAddress.isUnresolved()) {
            throw new IllegalArgumentException("socketAddress is unresolved : " + socketAddress + " : check your DNS settings");
        }
    }
}

