/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;
import weblogic.management.commo.DescriptorSupport;

public class DescriptorSupportBase
extends DescriptorSupport
implements Descriptor {
    HashMap descriptor;
    private static final int DEFAULT_SIZE = 20;
    public static String currClass = "DescriptorSupportBase";
    static final long serialVersionUID = -2599877740461261061L;

    protected DescriptorSupportBase() {
        this.descriptor = new HashMap(20);
    }

    public DescriptorSupportBase(int n) throws MBeanException, RuntimeOperationsException {
        if (n <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor field limit is invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(n);
    }

    protected DescriptorSupportBase(DescriptorSupportBase descriptorSupportBase) {
        this.descriptor = descriptorSupportBase == null || descriptorSupportBase.descriptor == null ? new HashMap(20) : new HashMap(descriptorSupportBase.descriptor);
    }

    protected DescriptorSupportBase(String string) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor is null or invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(20);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<> \t\n\r\f");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase("FIELD")) {
                bl = true;
                continue;
            }
            if (string4.equalsIgnoreCase("/FIELD")) {
                if (string2 != null && string3 != null) {
                    this.setField(string2.toLowerCase(), string3);
                }
                string2 = null;
                string3 = null;
                bl = false;
                continue;
            }
            if (string4.equalsIgnoreCase("DESCRIPTOR")) {
                bl2 = true;
                continue;
            }
            if (string4.equalsIgnoreCase("/DESCRIPTOR")) {
                bl2 = false;
                string2 = null;
                string3 = null;
                bl = false;
                continue;
            }
            if (!bl || !bl2) continue;
            int n = string4.indexOf("=");
            if (n > 0) {
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                if (string5.equalsIgnoreCase("NAME")) {
                    string2 = new String(string6);
                    continue;
                }
                if (string5.equalsIgnoreCase("VALUE")) {
                    string3 = new String(string6);
                    continue;
                }
                throw new XMLParseException("expected a field value, received '" + string4 + "'");
            }
            throw new XMLParseException("expected keyword=value, received '" + string4 + "'");
        }
    }

    protected DescriptorSupportBase(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (stringArray == null && objectArray == null || stringArray.length == 0 && objectArray.length == 0) {
            this.descriptor = new HashMap(20);
            return;
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames or FieldValues are null or invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setField(stringArray[i], objectArray[i]);
        }
    }

    protected DescriptorSupportBase(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.descriptor = new HashMap(20);
            return;
        }
        this.descriptor = new HashMap(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) continue;
            int n = stringArray[i].indexOf("=");
            if (n <= 0) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no equals sign"), "Exception occured trying to construct a descriptor");
            }
            String string = stringArray[i].substring(0, n);
            String string2 = null;
            if (n < stringArray[i].length()) {
                string2 = stringArray[i].substring(n + 1);
            }
            if (string == null || string.equals("")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no equals sign"), "Exception occured trying to construct a descriptor");
            }
            this.setField(string, string2);
        }
    }

    public Object getFieldValue(String string) throws RuntimeOperationsException {
        Object object = this.getFieldValueX(string);
        if (object == null && string.equalsIgnoreCase("displayname")) {
            return this.getFieldValue("Name");
        }
        return object;
    }

    protected Object getFieldValueX(String string) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname requested is null"), "Exception occured trying to get a field from a descriptor");
        }
        Object v = this.descriptor.get(string.toLowerCase());
        return v;
    }

    public void setField(String string, Object object) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname to be set is null"), "Exception occured trying to set a field from a descriptor");
        }
        String string2 = string.toLowerCase();
        if (!this.validateField(string2, object)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Field value invalid: " + string2 + "=" + object), "Field " + string2 + "=" + object + " is invalid. Exception occured trying to set a field from a descriptor");
        }
        this.descriptor.put(string2, object);
    }

    public String[] getFields() {
        if (this.descriptor == null) {
            return new String[0];
        }
        int n = this.descriptor.size();
        if (n == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n];
        stringArray = this.getFieldsI(stringArray, 0);
        return stringArray;
    }

    public String[] getFieldNames() {
        if (this.descriptor == null) {
            return new String[0];
        }
        int n = this.descriptor.size();
        Vector vector = new Vector(n);
        this.getFieldNamesI(vector);
        String[] stringArray = new String[vector.size()];
        return vector.toArray(stringArray);
    }

    public Object[] getFieldValues(String[] stringArray) {
        if (this.descriptor == null || stringArray != null && stringArray.length == 0) {
            return new Object[0];
        }
        int n = this.descriptor.size();
        Set set = this.descriptor.entrySet();
        if (set == null || n == 0) {
            return new Object[0];
        }
        Object[] objectArray = stringArray != null ? new Object[stringArray.length] : new Object[n];
        int n2 = 0;
        if (stringArray == null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                objectArray[n2] = entry == null || entry.getKey() == null ? null : new String((String)entry.getValue());
                ++n2;
            }
        } else {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                objectArray[n2] = stringArray[n2] == null || stringArray[n2].equals("") ? null : this.getFieldValue(stringArray[n2]);
            }
        }
        return objectArray;
    }

    public void setFields(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (stringArray == null && objectArray == null || stringArray.length == 0 && objectArray.length == 0) {
            return;
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames and FieldValues are null or invalid"), "Exception occured trying to set object fields a descriptor");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames is null or invalid"), "Exception occured trying to set object fields a descriptor");
            }
            this.setField(stringArray[i], objectArray[i]);
        }
    }

    public Object clone() throws RuntimeOperationsException {
        return new DescriptorSupportBase(this);
    }

    public void removeField(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.descriptor.remove(string);
    }

    public boolean isValid() throws RuntimeOperationsException {
        Set set = this.descriptor.entrySet();
        if (set == null) {
            return false;
        }
        String string = (String)this.getFieldValue("name");
        String string2 = (String)this.getFieldValue("descriptorType");
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getValue() == null || this.validateField(entry.getKey().toString(), entry.getValue().toString())) continue;
            return false;
        }
        return true;
    }

    private boolean validateField(String string, Object object) {
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = "";
        boolean bl = false;
        if (object != null && object instanceof String) {
            string2 = (String)object;
            bl = true;
        }
        if (string.equalsIgnoreCase("Name") || string.equalsIgnoreCase("DescriptorType") || string.equalsIgnoreCase("SetMethod") || string.equalsIgnoreCase("GetMethod") || string.equalsIgnoreCase("Role") || string.equalsIgnoreCase("Class")) {
            return object != null && bl;
        }
        if (string.equalsIgnoreCase("visibility")) {
            int n;
            if (object != null && bl) {
                n = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                n = (Integer)object;
            } else {
                return false;
            }
            return n >= 1 && n <= 4;
        }
        if (string.equalsIgnoreCase("severity")) {
            int n;
            if (object != null && bl) {
                n = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                n = (Integer)object;
            } else {
                return false;
            }
            return n >= 0 && n <= 5;
        }
        if (string.equalsIgnoreCase("PersistPolicy")) {
            return object != null && bl && (string2.equalsIgnoreCase("OnUpdate") || string2.equalsIgnoreCase("OnTimer") || string2.equalsIgnoreCase("NoMoreOftenThan") || string2.equalsIgnoreCase("Always") || string2.equalsIgnoreCase("Never"));
        }
        if (string.equalsIgnoreCase("PersistPeriod") || string.equalsIgnoreCase("CurrencyTimeLimit") || string.equalsIgnoreCase("LastUpdatedTimeStamp") || string.equalsIgnoreCase("LastReturnedTimeStamp")) {
            int n;
            if (object != null && bl) {
                n = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                n = (Integer)object;
            } else {
                return false;
            }
            return n >= -1;
        }
        if (string.equalsIgnoreCase("ReadOnly") || string.equalsIgnoreCase("log") || string.equalsIgnoreCase("Iterable")) {
            return object instanceof Boolean || bl && (string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("F") || string2.equalsIgnoreCase("false"));
        }
        return true;
    }

    public String toXMLString() {
        String string = new String("<Descriptor>");
        Set set = this.descriptor.entrySet();
        if (set == null) {
            return null;
        }
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry != null) {
                string = entry.getValue() == null ? string + "<field name=\"" + entry.getKey().toString() + "\" value=\"null\"></field>" : string + "<field name=\"" + entry.getKey().toString() + "\" value=\"" + entry.getValue().toString() + "\"></field>";
            }
            ++n;
        }
        string = string + "</Descriptor>";
        return string;
    }

    public String toString() {
        String string = "";
        String[] stringArray = this.getFields();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = i == stringArray.length - 1 ? string.concat(stringArray[i]) : string.concat(stringArray[i] + ", ");
        }
        return string;
    }

    private int toNumeric(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
        return n;
    }

    protected int getFieldCount() {
        return this.descriptor.size();
    }

    protected int getVoidCount() {
        return 0;
    }

    String[] getFieldsI(String[] stringArray, int n) {
        if (this.descriptor == null) {
            return stringArray;
        }
        int n2 = this.descriptor.size();
        if (n2 == 0) {
            return stringArray;
        }
        Set set = this.descriptor.entrySet();
        if (set == null) {
            return stringArray;
        }
        int n3 = n;
        Object object = null;
        Map.Entry entry = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry != null) {
                object = entry.getValue();
                stringArray[n3] = object == null ? new String(entry.getKey().toString() + "=") : (object instanceof String ? new String(entry.getKey().toString() + "=" + object.toString()) : new String(entry.getKey().toString() + "=(" + object.toString() + ")"));
            }
            ++n3;
        }
        return stringArray;
    }

    void getFieldNamesI(Vector vector) {
        Set set = this.descriptor.entrySet();
        if (set == null || set.size() == 0) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getKey() == null) continue;
            vector.add(new String(entry.getKey().toString()));
        }
    }

    void getFieldPairsI(HashMap hashMap) {
        Set set = this.descriptor.entrySet();
        if (set == null || set.size() == 0) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getKey() == null) continue;
            hashMap.put(entry.getKey(), new DescriptorSupport.Pair(entry.getKey().toString(), entry.getValue()));
        }
    }

    protected int getFieldCountLocal() {
        return this.getFieldCount();
    }
}

