/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commo;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarFile {
    public static final boolean CLOSE_STREAM = true;
    public static final boolean DONT_CLOSE_STREAM = false;
    private transient Hashtable manifest;
    private transient Hashtable manifestAttributes;
    private transient Vector manifestEntries;
    private transient ZipFile jarFile;
    private transient Hashtable newEntries;

    public JarFile(File file) throws IOException, ZipException {
        this.jarFile = new ZipFile(file);
        this.readManifest();
    }

    private static void addDir(File file, File file2, ZipOutputStream zipOutputStream, boolean bl) throws IOException, FileNotFoundException {
        String string;
        String string2 = string = file2.getAbsolutePath();
        String string3 = file.getAbsolutePath();
        String string4 = System.getProperty("file.separator");
        if (!string.endsWith(string4)) {
            string = string + string4;
        }
        if (!string3.endsWith(string4)) {
            string3 = string3 + string4;
        }
        int n = string3.length();
        String[] stringArray = file2.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file3 = new File(string + stringArray[i]);
            if (file3.isDirectory()) {
                JarFile.addDir(file, file3, zipOutputStream, bl);
                continue;
            }
            JarFile.addFile(file, file3, zipOutputStream, bl);
        }
        if (bl) {
            boolean bl2 = file2.delete();
        }
    }

    static void addFile(File file, File file2, ZipOutputStream zipOutputStream, boolean bl) throws IOException {
        String string;
        String string2 = file.getAbsolutePath();
        if (!string2.endsWith(string = System.getProperty("file.separator"))) {
            string2 = string2 + string;
        }
        int n = string2.length();
        String string3 = file2.getAbsolutePath();
        String string4 = string3.substring(n);
        String string5 = string4.replace(File.separatorChar, '/');
        ZipEntry zipEntry = new ZipEntry(string5);
        FileInputStream fileInputStream = new FileInputStream(file2);
        zipEntry.setMethod(8);
        zipOutputStream.putNextEntry(zipEntry);
        JarFile.copyBytes(fileInputStream, zipOutputStream);
        zipOutputStream.closeEntry();
        fileInputStream.close();
        if (bl) {
            file2.delete();
        }
    }

    static void add(File file, File file2, ZipOutputStream zipOutputStream, boolean bl) throws IOException {
        if (file2.isDirectory()) {
            JarFile.addDir(file, file2, zipOutputStream, bl);
        } else {
            JarFile.addFile(file, file2, zipOutputStream, bl);
        }
    }

    public static void create(File file, File file2, boolean bl) throws IOException, ZipException {
        if (!file.isDirectory()) {
            throw new FileNotFoundException("Not a directory");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        JarFile.addDir(file, file, zipOutputStream, bl);
        zipOutputStream.close();
    }

    static void create(File file, File file2, File[] fileArray, boolean bl) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        for (int i = 0; i < fileArray.length; ++i) {
            JarFile.add(file, fileArray[i], zipOutputStream, bl);
        }
        zipOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarFile(File file, File file2) throws IOException, ZipException {
        Object object;
        Object object2;
        File file3 = file2.getParentFile();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.readManifest(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
        Enumeration enumeration = this.manifestEntries.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (Hashtable)this.manifest.get(object2);
            this.addEntry((String)object2, new File(file3, (String)object2), (Hashtable)object);
        }
        object2 = new ZipEntry("META-INF/MANIFEST.MF");
        object = new ZipOutputStream(new FileOutputStream(file2));
        ((ZipOutputStream)object).putNextEntry((ZipEntry)object2);
        fileInputStream = new FileInputStream(file);
        try {
            JarFile.copyBytes(fileInputStream, (OutputStream)object);
        }
        finally {
            ((ZipOutputStream)object).closeEntry();
            fileInputStream.close();
        }
        this.write(this.manifestEntries.elements(), this.newEntries, null, (ZipOutputStream)object);
        ((ZipOutputStream)object).close();
    }

    public Hashtable getManifest() {
        return this.manifest;
    }

    public ZipEntry getEntry(String string) {
        return this.jarFile.getEntry(string);
    }

    public ZipFile getZipFile() {
        return this.jarFile;
    }

    public InputStream getEntryStream(String string) throws FileNotFoundException {
        try {
            string = string.replace(File.separatorChar, '/');
            ZipEntry zipEntry = this.jarFile.getEntry(string);
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = this.jarFile.getInputStream(zipEntry);
            return inputStream;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string + " not read");
        }
    }

    public Enumeration getEntries() {
        return this.jarFile.entries();
    }

    public void write(File file) throws IOException, ZipException {
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.putNextEntry(zipEntry);
        PrintStream printStream = new PrintStream(zipOutputStream);
        printStream.println(this.toString());
        printStream.flush();
        zipOutputStream.closeEntry();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("META-INF/MANIFEST.MF", "");
        Enumeration<? extends ZipEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry2 = enumeration.nextElement();
            if (hashtable.get(zipEntry2.getName()) != null) continue;
            ZipEntry zipEntry3 = new ZipEntry(zipEntry2.getName());
            zipEntry3.setMethod(8);
            zipOutputStream.putNextEntry(zipEntry3);
            this.zipEntryToOutputStream(zipEntry2, zipOutputStream, false);
            zipOutputStream.closeEntry();
            hashtable.put(zipEntry2.getName(), "");
        }
        if (this.newEntries != null) {
            this.write(this.newEntries.keys(), this.newEntries, hashtable, zipOutputStream);
        }
        zipOutputStream.close();
    }

    public void extract(String string) throws IOException, ZipException {
        Enumeration<? extends ZipEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName().replace('/', File.separatorChar);
            String string3 = string + System.getProperty("file.separator") + string2;
            String string4 = string3.substring(string3.lastIndexOf(File.separatorChar) + 1);
            String string5 = string3.substring(0, string3.lastIndexOf(File.separatorChar));
            if (string4 == null || string4.equals("")) continue;
            File file = new File(string5);
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException("Couldn't make directories for " + file);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            this.zipEntryToOutputStream(zipEntry, fileOutputStream, !enumeration.hasMoreElements());
            fileOutputStream.close();
        }
    }

    public void write(Enumeration enumeration, Hashtable hashtable, Hashtable hashtable2, ZipOutputStream zipOutputStream) throws IOException, ZipException {
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable2 != null && hashtable2.get(string) != null) continue;
            FileInputStream fileInputStream = new FileInputStream((File)hashtable.get(string));
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(8);
            zipOutputStream.putNextEntry(zipEntry);
            JarFile.copyBytes(fileInputStream, zipOutputStream);
            fileInputStream.close();
            zipOutputStream.closeEntry();
            if (hashtable2 == null) continue;
            hashtable2.put(string, "");
        }
    }

    private static void copyBytes(FileInputStream fileInputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[512];
        int n = 0;
        while ((n = fileInputStream.read(byArray, 0, 512)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void zipEntryToOutputStream(ZipEntry zipEntry, OutputStream outputStream, boolean bl) throws IOException {
        InputStream inputStream;
        block3: {
            int n;
            byte[] byArray = new byte[512];
            int n2 = 0;
            inputStream = this.jarFile.getInputStream(zipEntry);
            try {
                for (n = (int)zipEntry.getSize(); n > 0 && (n2 = inputStream.read(byArray, 0, Math.min(n, 512))) != -1; n -= n2) {
                    outputStream.write(byArray, 0, n2);
                }
            }
            catch (EOFException eOFException) {
                if (n == 0) break block3;
                throw eOFException;
            }
        }
        inputStream.close();
    }

    public void addEntry(String string, File file, Hashtable hashtable) {
        if (this.newEntries == null) {
            this.newEntries = new Hashtable();
        }
        this.newEntries.put(string, file);
        if (hashtable != null) {
            this.manifest.put(string, hashtable);
        }
    }

    public String toString() {
        String string;
        if (this.manifest == null) {
            return "[No Manifest]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.manifestAttributes.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append(string + ": " + this.manifestAttributes.get(string) + "\n\n");
        }
        enumeration = this.manifest.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Object v = this.manifest.get(string);
            if (v instanceof Hashtable) {
                Hashtable hashtable = (Hashtable)v;
                if (hashtable == null) continue;
                String string2 = (String)hashtable.get("name");
                stringBuffer.append("Name: " + string2 + "\n");
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    string = (String)enumeration2.nextElement();
                    if (string.equals("name")) continue;
                    stringBuffer.append(string + ": " + hashtable.get(string) + "\n");
                }
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void readManifest() throws IOException, ZipException {
        ZipEntry zipEntry = this.getEntry("META-INF/MANIFEST.MF");
        if (zipEntry == null) {
            return;
        }
        this.readManifest(this.jarFile.getInputStream(zipEntry));
    }

    private void readManifest(InputStream inputStream) throws IOException, ZipException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.manifest = new Hashtable();
        this.manifestEntries = new Vector();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        int n = 0;
        while (true) {
            block7: {
                try {
                    string = bufferedReader.readLine();
                    if (string == null) break;
                    n += string.length() + 2;
                }
                catch (EOFException eOFException) {
                    if (!eOFException.getMessage().equals("Unexpected end of ZLIB input stream")) break block7;
                    if (string == null || string.length() == 0) break;
                    throw eOFException;
                }
            }
            int n2 = string.indexOf(":");
            if (n2 != -1) {
                String string2 = string.substring(0, n2).toLowerCase();
                String string3 = string.substring(n2 + 1).trim();
                if (string2.equals("name")) {
                    this.manifest.put(string3, hashtable);
                    this.manifestEntries.addElement(string3);
                    string2 = "name";
                }
                if (hashtable == null) {
                    if (this.manifestAttributes == null) {
                        this.manifestAttributes = new Hashtable();
                    }
                    this.manifestAttributes.put(string2, string3);
                    continue;
                }
                hashtable.put(string2, string3);
                continue;
            }
            hashtable = new Hashtable();
        }
        bufferedReader.close();
    }

    public void close() {
        try {
            this.jarFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws IOException, ZipException {
        switch (stringArray.length) {
            case 1: {
                JarFile jarFile = new JarFile(new File(stringArray[0]));
                break;
            }
            case 2: {
                JarFile jarFile = new JarFile(new File(stringArray[0]), new File(stringArray[1]));
                break;
            }
            default: {
                System.out.println("usage: JarFile [manifest] JarFile");
                return;
            }
        }
    }
}

