/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commo;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.management.commo.CommoProcess;
import weblogic.management.commo.DiabloIntfCodeGenerator;
import weblogic.management.commo.ImplCodeGenerator;
import weblogic.management.commo.JarFileObject;
import weblogic.management.commo.XMLFileNameFilter;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.JavaExec;
import weblogic.utils.StringUtils;
import weblogic.utils.compiler.CompilerInvoker;

public class WebLogicMBeanMaker {
    public static final String EXTENSIONS_XML_NAMESPACE = "http://www.bea.com/ns/weblogic/90/security/extension";
    public static final String QNAME_COMPATIBILITY_PROP = "com.sun.xml.namespace.QName.useCompatibleSerialVersionUID";
    private static String DOC_XML_EXT = "-doc.xml";
    private static Pattern pattern = Pattern.compile(".*(<Lead>|<Detail>)(.*)(</Lead>|</Detail>)", 32);
    private static Transformer transformer;
    private static List mbeanTypeAttributesNotSupportedIn90;
    private static List mbeanAttributesNotSupportedIn90;
    private static List mbeanOperationsNotSupportedIn90;
    private static List mbeanOperationsArgNotSupportedIn90;
    static Getopt2 opts;
    boolean compileDone = false;
    boolean error = false;
    Node root = null;
    String mBeanName = null;
    String fileDir = ".\\temp";
    String mdf = null;
    String mdfDir;
    String mjf = null;
    String mbeantypesDir = null;
    String fileLoc = null;
    String compiler = null;
    String source = null;
    String target = null;
    boolean includeSource = false;
    boolean createStubs = false;
    boolean preserveStubs = true;
    boolean validating = false;
    boolean verbose = false;
    boolean helpRequested = false;
    boolean compileDebug = false;
    boolean noCompile;
    Vector attributes;
    Vector operations;
    Vector notifications;
    Vector constructors;
    Vector implementsSet;
    Vector imports;
    String classpath;
    HashMap attributeDescriptionMap = new HashMap();
    boolean isDocFileLoaded = false;
    String mdfPath = "";
    private static final String JAVAC_COMPILER_CLASS = "com.sun.tools.javac.Main";
    boolean doBeanGen = true;
    boolean internalWLSBuild;
    String targetNameSpace = null;
    String schemaLocation = null;
    boolean doCheckDescription;
    String jvmArgs = null;

    private static void populateNotSupportedList() {
        mbeanTypeAttributesNotSupportedIn90.add("CachingDisabled");
        mbeanTypeAttributesNotSupportedIn90.add("Classification");
        mbeanTypeAttributesNotSupportedIn90.add("CurrencyTimeLimit");
        mbeanTypeAttributesNotSupportedIn90.add("DisplayMessage");
        mbeanTypeAttributesNotSupportedIn90.add("Export");
        mbeanTypeAttributesNotSupportedIn90.add("GenerateExtendedAccessors");
        mbeanTypeAttributesNotSupportedIn90.add("InstanceExtent");
        mbeanTypeAttributesNotSupportedIn90.add("LanguageMap");
        mbeanTypeAttributesNotSupportedIn90.add("Listen");
        mbeanTypeAttributesNotSupportedIn90.add("Log");
        mbeanTypeAttributesNotSupportedIn90.add("LogFile");
        mbeanTypeAttributesNotSupportedIn90.add("MBeanClassName");
        mbeanTypeAttributesNotSupportedIn90.add("MessageID");
        mbeanTypeAttributesNotSupportedIn90.add("PersistLocation");
        mbeanTypeAttributesNotSupportedIn90.add("PersistName");
        mbeanTypeAttributesNotSupportedIn90.add("PersistPeriod");
        mbeanTypeAttributesNotSupportedIn90.add("Readable");
        mbeanTypeAttributesNotSupportedIn90.add("Servers");
        mbeanTypeAttributesNotSupportedIn90.add("VersionID");
        mbeanTypeAttributesNotSupportedIn90.add("Visibility");
        mbeanTypeAttributesNotSupportedIn90.add("Writeable");
        mbeanAttributesNotSupportedIn90.add("CachingDisabled");
        mbeanAttributesNotSupportedIn90.add("CurrencyTimeLimit");
        mbeanAttributesNotSupportedIn90.add("DefaultString");
        mbeanAttributesNotSupportedIn90.add("DisplayMessage");
        mbeanAttributesNotSupportedIn90.add("Export");
        mbeanAttributesNotSupportedIn90.add("GenerateExtendedAccessors");
        mbeanAttributesNotSupportedIn90.add("GetMethod");
        mbeanAttributesNotSupportedIn90.add("Iterable");
        mbeanAttributesNotSupportedIn90.add("LanguageMap");
        mbeanAttributesNotSupportedIn90.add("Listen");
        mbeanAttributesNotSupportedIn90.add("Log");
        mbeanAttributesNotSupportedIn90.add("LogFile");
        mbeanAttributesNotSupportedIn90.add("MessageID");
        mbeanAttributesNotSupportedIn90.add("NoDump");
        mbeanAttributesNotSupportedIn90.add("PersistentLocation");
        mbeanAttributesNotSupportedIn90.add("PersistentName");
        mbeanAttributesNotSupportedIn90.add("PersistPeriod");
        mbeanAttributesNotSupportedIn90.add("PersistPolicy");
        mbeanAttributesNotSupportedIn90.add("ProtocolMap");
        mbeanAttributesNotSupportedIn90.add("Readable");
        mbeanAttributesNotSupportedIn90.add("SetMethod");
        mbeanAttributesNotSupportedIn90.add("Visibility");
        mbeanOperationsNotSupportedIn90.add("CurrencyTimeLimit");
        mbeanOperationsNotSupportedIn90.add("DisplayMessage");
        mbeanOperationsNotSupportedIn90.add("DisplayName");
        mbeanOperationsNotSupportedIn90.add("Impact");
        mbeanOperationsNotSupportedIn90.add("LanguageMap");
        mbeanOperationsNotSupportedIn90.add("Listen");
        mbeanOperationsNotSupportedIn90.add("MessageID");
        mbeanOperationsNotSupportedIn90.add("PresentationString");
        mbeanOperationsNotSupportedIn90.add("ReturnTypeDescription");
        mbeanOperationsNotSupportedIn90.add("Visibility");
        mbeanOperationsArgNotSupportedIn90.add("InterfaceType");
    }

    private static void dumpUnsupportedWarnings(Node node) {
        Object object;
        WebLogicMBeanMaker.populateNotSupportedList();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            object = node2.getNodeName();
            if (!mbeanTypeAttributesNotSupportedIn90.contains(object)) continue;
            System.out.println("<Warning> The MDF attribute '" + (String)object + "' is not supported in 9.0 and will be ignored. " + "Please remove it from your MDF (.xml file)");
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node3;
            int n;
            NamedNodeMap namedNodeMap2;
            object = nodeList.item(i);
            if (object.getNodeType() != 1) continue;
            if ("MBeanAttribute".equals(object.getNodeName())) {
                namedNodeMap2 = object.getAttributes();
                for (n = 0; n < namedNodeMap2.getLength(); ++n) {
                    node3 = namedNodeMap2.item(n);
                    string = node3.getNodeName();
                    if (!mbeanAttributesNotSupportedIn90.contains(string)) continue;
                    System.out.println("<warning> The MDF attribute '" + string + "' is not supported in 9.0 and will be ignored. " + "Please remove it from your MDF (.xml file)");
                }
                continue;
            }
            if ("MBeanOperation".equals(object.getNodeName())) {
                namedNodeMap2 = object.getAttributes();
                for (n = 0; n < namedNodeMap2.getLength(); ++n) {
                    node3 = namedNodeMap2.item(n);
                    string = node3.getNodeName();
                    if (!mbeanOperationsNotSupportedIn90.contains(string)) continue;
                    System.out.println("<warning> The MDF attribute '" + string + "' is not supported in 9.0 and will be ignored. " + "Please remove it from your MDF (.xml file)");
                }
                continue;
            }
            if ("MBeanOperationArg".equals(object.getNodeName())) {
                namedNodeMap2 = object.getAttributes();
                for (n = 0; n < namedNodeMap2.getLength(); ++n) {
                    node3 = namedNodeMap2.item(n);
                    string = node3.getNodeName();
                    if (!mbeanOperationsArgNotSupportedIn90.contains(string)) continue;
                    System.out.println("<warning> The MDF attribute '" + string + "' is not supported in 9.0 and will be ignored. " + "Please remove it from your MDF (.xml file)");
                }
                continue;
            }
            if (!"MBeanNotification".equals(object.getNodeName())) continue;
            System.out.println("<warning> The MDF attribute '" + object.getNodeName() + "' and it contents are not supported in 9.0 and will be ignored. " + "Please remove it from your MDF (.xml file)");
        }
    }

    private static void verifyProviderClassNameCollision(Node node, Node node2) {
        Node node3;
        int n;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            node3 = namedNodeMap.item(n);
            if (!node3.getNodeName().equals("Name") || !node3.getNodeValue().equals("ProviderClassName")) continue;
            bl = true;
        }
        if (bl) {
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                node3 = namedNodeMap.item(n);
                if (!node3.getNodeName().equals("Default")) continue;
                string4 = node3.getNodeValue();
                string4 = StringUtils.replaceGlobal((String)string4, (String)"\"", (String)"");
                break;
            }
            NamedNodeMap namedNodeMap2 = node.getAttributes();
            for (int i = 0; i < namedNodeMap2.getLength(); ++i) {
                Node node4 = namedNodeMap2.item(i);
                if (node4.getNodeName().equals("Name")) {
                    string2 = node4.getNodeValue();
                    continue;
                }
                if (!node4.getNodeName().equals("Package")) continue;
                string3 = node4.getNodeValue();
            }
        }
        if (string4.equals(string = string3 + "." + string2 + "Impl")) {
            throw new RuntimeException("ProviderClassName '" + string4 + "' specified in your MDF (.xml file) collides " + "with the name of the customizer that will be " + "generated by the WebLogicMBeanMaker. " + "Please choose a different ProviderClassName and retry.");
        }
    }

    public WebLogicMBeanMaker() {
        this.attributes = new Vector();
        this.operations = new Vector();
        this.notifications = new Vector();
        this.constructors = new Vector();
        this.imports = new Vector();
        this.implementsSet = new Vector();
        this.attributeDescriptionMap = new HashMap();
    }

    private void displayUsage() {
        opts.usageAndExit("weblogic.management.commo.WebLogicMBeanMaker");
    }

    public static synchronized void main(String[] stringArray) throws Exception {
        WebLogicMBeanMaker webLogicMBeanMaker = new WebLogicMBeanMaker();
        opts = new Getopt2();
        opts.setFailOnUnrecognizedOpts(true);
        opts.addOption("MDF", "MDF file name", "The MBean Description File (MDF).  This or MDFDIR required if MJF is not provided.");
        opts.addOption("MDFDIR", "MDF directory name", "A directory of MBean Description Files (MDFs).  This or MDF required if MJF is not provided.");
        opts.addOption("files", "Generated file directory", "The directory to contain the generated files. Required unless both MJF and MDF (or MDFDIR) are provided.");
        opts.addOption("MJF", "MJF (jar) file name", "The filename of the generated MJF (MBean jar file). Required if MDF or MDFDIR is not provided.");
        opts.addOption("compiler", "Compiler name", "The compiler to use for Java compilation.");
        opts.addOption("source", "Source version", "The source version for Java compilation.");
        opts.addOption("target", "Target version", "The target version for Java compilation.");
        opts.addOption("classpath", "Classpath", "The classpath to use for Java compilation");
        opts.addOption("mbeantypesDir", "jar library directory", "The location of a jar library containing existing provider jars");
        opts.addFlag("includeSource", "Should generated source files be included in the MJF.");
        opts.addFlag("createStubs", "Should stub files be generated for operations and custom attribute accessor methods.");
        opts.addFlag("doBeanGen", "Temp flag to disable bean gen.");
        opts.markPrivate("doBeanGen");
        opts.addFlag("doCheckDescription", "Internal flag to print message when description text is not in a doc file.");
        opts.markPrivate("doCheckDescription");
        opts.addFlag("preserveStubs", "When generating stubs do not overwrite existing source files if they exist.");
        opts.addFlag("validateXML", "Should the XML processor do validation.");
        opts.addFlag("g", "Compile generated files with the debug option.");
        opts.addFlag("verbose", "Causes additonal output messages.");
        opts.addFlag("noCompile", "Supresses Compilation.");
        opts.addFlag("internalWLSBuild", "Internal flag, do not use this flag.");
        opts.markPrivate("internalWLSBuild");
        opts.addOption("targetNameSpace", "The default name space for the generated schemas", "Target Name space for the schema generated by the Maker. By default this is set to http://www.bea.com/ns/weblogic/90/security/extension");
        opts.addOption("schemaLocation", "The location where generated schemas will be stored", "The schema location for generated schemas. Default is null");
        opts.addOption("jvmArgs", "JVM arguments", "The JVM arguments to pass to subprocesses. Arguments should be separated by spaces. Default is null");
        opts.addFlag("help", "Print out this message.");
        try {
            stringArray = opts.grok(stringArray).args();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("\nError: " + illegalArgumentException.getMessage() + "\n");
            webLogicMBeanMaker.displayUsage();
        }
        webLogicMBeanMaker.mdf = opts.getOption("MDF");
        webLogicMBeanMaker.mdfDir = opts.getOption("MDFDIR");
        webLogicMBeanMaker.noCompile = opts.hasOption("noCompile");
        webLogicMBeanMaker.mjf = opts.getOption("MJF");
        webLogicMBeanMaker.mbeantypesDir = opts.getOption("mbeantypesDir");
        webLogicMBeanMaker.fileLoc = opts.getOption("files");
        webLogicMBeanMaker.compiler = opts.getOption("compiler");
        webLogicMBeanMaker.source = opts.getOption("source");
        webLogicMBeanMaker.target = opts.getOption("target");
        webLogicMBeanMaker.classpath = opts.getOption("classpath");
        webLogicMBeanMaker.includeSource = opts.hasOption("includeSource");
        webLogicMBeanMaker.createStubs = opts.hasOption("createStubs");
        webLogicMBeanMaker.doBeanGen = true;
        webLogicMBeanMaker.preserveStubs = opts.hasOption("preserveStubs");
        webLogicMBeanMaker.validating = opts.hasOption("validateXML");
        webLogicMBeanMaker.compileDebug = opts.hasOption("g");
        webLogicMBeanMaker.verbose = opts.hasOption("verbose");
        webLogicMBeanMaker.doCheckDescription = opts.hasOption("doCheckDescription");
        webLogicMBeanMaker.helpRequested = opts.hasOption("help");
        webLogicMBeanMaker.internalWLSBuild = opts.hasOption("internalWLSBuild");
        webLogicMBeanMaker.targetNameSpace = opts.getOption("targetNameSpace");
        webLogicMBeanMaker.schemaLocation = opts.getOption("schemaLocation");
        webLogicMBeanMaker.jvmArgs = opts.getOption("jvmArgs");
        try {
            Object object;
            String[] stringArray2;
            Object object2;
            Object object3;
            Object object4;
            File file;
            Object object5;
            if (webLogicMBeanMaker.mdf == null) {
                webLogicMBeanMaker.mdf = System.getProperty("MDF");
            }
            if (!webLogicMBeanMaker.noCompile) {
                webLogicMBeanMaker.noCompile = Boolean.getBoolean("noCompile");
            }
            if (webLogicMBeanMaker.mdfDir == null) {
                webLogicMBeanMaker.mdfDir = System.getProperty("MDFDIR");
            }
            if (webLogicMBeanMaker.mjf == null) {
                webLogicMBeanMaker.mjf = System.getProperty("MJF");
            }
            if (webLogicMBeanMaker.mbeantypesDir == null) {
                webLogicMBeanMaker.mbeantypesDir = System.getProperty("mbeantypesDir");
            }
            if (webLogicMBeanMaker.compiler == null) {
                webLogicMBeanMaker.compiler = System.getProperty("compiler");
            }
            if (webLogicMBeanMaker.source == null) {
                webLogicMBeanMaker.source = System.getProperty("source");
            }
            if (webLogicMBeanMaker.target == null) {
                webLogicMBeanMaker.target = System.getProperty("target");
            }
            if (webLogicMBeanMaker.fileLoc == null) {
                webLogicMBeanMaker.fileLoc = System.getProperty("files");
            }
            if (!webLogicMBeanMaker.includeSource) {
                webLogicMBeanMaker.includeSource = Boolean.getBoolean("includeSource");
            }
            if (!webLogicMBeanMaker.createStubs) {
                webLogicMBeanMaker.createStubs = Boolean.getBoolean("createStubs");
            }
            if (!webLogicMBeanMaker.preserveStubs) {
                webLogicMBeanMaker.preserveStubs = Boolean.getBoolean("preserveStubs");
            }
            if (!webLogicMBeanMaker.validating) {
                webLogicMBeanMaker.validating = Boolean.getBoolean("validateXML");
            }
            if (!webLogicMBeanMaker.verbose) {
                webLogicMBeanMaker.verbose = Boolean.getBoolean("verbose");
            }
            if (!webLogicMBeanMaker.helpRequested) {
                webLogicMBeanMaker.helpRequested = Boolean.getBoolean("helpRequested");
            }
            if (!webLogicMBeanMaker.compileDebug) {
                webLogicMBeanMaker.compileDebug = Boolean.getBoolean("g");
            }
            if (webLogicMBeanMaker.targetNameSpace == null) {
                webLogicMBeanMaker.targetNameSpace = System.getProperty("targetNameSpace", EXTENSIONS_XML_NAMESPACE);
            }
            if (webLogicMBeanMaker.jvmArgs == null) {
                webLogicMBeanMaker.jvmArgs = System.getProperty("jvmArgs");
            }
            if (webLogicMBeanMaker.helpRequested) {
                webLogicMBeanMaker.displayUsage();
            }
            if (webLogicMBeanMaker.helpRequested) {
                webLogicMBeanMaker.displayUsage();
            }
            boolean bl = true;
            if (webLogicMBeanMaker.mdf == null && webLogicMBeanMaker.mdfDir == null && webLogicMBeanMaker.fileLoc == null && webLogicMBeanMaker.mjf == null) {
                bl = false;
            }
            if (webLogicMBeanMaker.mdf != null && webLogicMBeanMaker.mdfDir == null && webLogicMBeanMaker.fileLoc == null && webLogicMBeanMaker.mjf == null) {
                bl = false;
            }
            if (bl && webLogicMBeanMaker.mjf != null && webLogicMBeanMaker.fileLoc == null && webLogicMBeanMaker.mdf == null && webLogicMBeanMaker.mdfDir == null) {
                bl = false;
            }
            if (bl && webLogicMBeanMaker.fileLoc != null && webLogicMBeanMaker.mjf == null && webLogicMBeanMaker.mdf == null && webLogicMBeanMaker.mdfDir == null) {
                bl = false;
            }
            if (!bl) {
                System.out.println("\nAt least 2 of the following 3 options must be provided: 1)-MDF or MDFDIR 2) -files 3)-MJF\n");
                webLogicMBeanMaker.displayUsage();
            }
            if (webLogicMBeanMaker.mdf != null && webLogicMBeanMaker.mdfDir != null) {
                System.out.println("\nBoth MDF and MDFDIR cannot be provided in the same run.\n");
                webLogicMBeanMaker.displayUsage();
            }
            if (stringArray.length > 0) {
                System.out.println("\nThere are no parameters to this command, only options.  You have specifed " + stringArray.length + " parameters.\n");
                webLogicMBeanMaker.displayUsage();
            }
            if (webLogicMBeanMaker.mdf != null && webLogicMBeanMaker.mdfDir != null) {
                System.out.println("\nIt is illegal to specify both MDF and MDFDIR\n");
                webLogicMBeanMaker.displayUsage();
            }
            if (webLogicMBeanMaker.mdf != null && !new File(webLogicMBeanMaker.mdf).exists()) {
                System.out.println("\nThe specified MDF file, \"" + webLogicMBeanMaker.mdf + "\", does not exist.\n");
                System.exit(1);
            }
            if (webLogicMBeanMaker.mdfDir != null && !new File(webLogicMBeanMaker.mdfDir).exists()) {
                System.out.println("\nThe specified MDF directory, \"" + webLogicMBeanMaker.mdfDir + "\", does not exist.\n");
                System.exit(1);
            }
            if (webLogicMBeanMaker.mdf == null && webLogicMBeanMaker.mdfDir == null) {
                object5 = new File(webLogicMBeanMaker.fileLoc);
                if (!object5.exists()) {
                    System.out.println("\nThe specified input files directory, \"" + webLogicMBeanMaker.fileLoc + "\", does not exist.\n");
                    System.exit(1);
                }
                if (!object5.isDirectory()) {
                    System.out.println("\nThe specified input files location, \"" + webLogicMBeanMaker.fileLoc + "\", is not a directory.\n");
                    System.exit(1);
                }
            }
            if (webLogicMBeanMaker.fileLoc != null) {
                object5 = new File(webLogicMBeanMaker.fileLoc);
                if (!object5.exists()) {
                    object5.mkdirs();
                }
                webLogicMBeanMaker.fileDir = webLogicMBeanMaker.fileLoc;
            }
            object5 = null;
            if (webLogicMBeanMaker.mdf != null) {
                object5 = new File[]{new File(webLogicMBeanMaker.mdf)};
            } else if (webLogicMBeanMaker.mdfDir != null) {
                object5 = new File(webLogicMBeanMaker.mdfDir).listFiles(new XMLFileNameFilter());
            }
            if (object5 != null) {
                for (int i = 0; i < ((File)object5).length; ++i) {
                    if (object5[i].getName().endsWith(DOC_XML_EXT)) continue;
                    file = object5[i];
                    webLogicMBeanMaker.isDocFileLoaded = false;
                    webLogicMBeanMaker.attributes = new Vector();
                    webLogicMBeanMaker.operations = new Vector();
                    webLogicMBeanMaker.notifications = new Vector();
                    webLogicMBeanMaker.constructors = new Vector();
                    webLogicMBeanMaker.imports = new Vector();
                    webLogicMBeanMaker.implementsSet = new Vector();
                    object4 = DocumentBuilderFactory.newInstance();
                    if (webLogicMBeanMaker.validating) {
                        ((DocumentBuilderFactory)object4).setValidating(true);
                    }
                    object3 = ((DocumentBuilderFactory)object4).newDocumentBuilder();
                    object2 = webLogicMBeanMaker.new MyErrorHandler();
                    ((DocumentBuilder)object3).setErrorHandler((ErrorHandler)object2);
                    if (webLogicMBeanMaker.verbose || webLogicMBeanMaker.mdf != null) {
                        System.out.println("Parsing the MBean definition file: " + file);
                    }
                    webLogicMBeanMaker.mdfPath = file.getParent();
                    stringArray2 = ((DocumentBuilder)object3).parse(file);
                    webLogicMBeanMaker.attributeDescriptionMap = new HashMap();
                    webLogicMBeanMaker.root = stringArray2.getDocumentElement();
                    if (stringArray2 != null) {
                        ArrayList arrayList;
                        Object object6;
                        Object object7;
                        object = webLogicMBeanMaker.root.getAttributes();
                        for (int j = 0; j < object.getLength(); ++j) {
                            Node node = object.item(j);
                            if (!webLogicMBeanMaker.verbose) continue;
                            System.out.println("Document attribute: " + node.getNodeName() + "=" + node.getNodeValue());
                        }
                        NodeList nodeList = webLogicMBeanMaker.root.getChildNodes();
                        for (int j = 0; j < nodeList.getLength(); ++j) {
                            object7 = nodeList.item(j);
                            if (object7.getNodeType() != 1) continue;
                            if ("MBeanAttribute".equals(object7.getNodeName())) {
                                try {
                                    WebLogicMBeanMaker.verifyProviderClassNameCollision(webLogicMBeanMaker.root, (Node)object7);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            object6 = object7.getAttributes();
                            for (int k = 0; k < object6.getLength(); ++k) {
                                Node node = object6.item(k);
                                if (!webLogicMBeanMaker.verbose) continue;
                                System.out.println(node.getNodeName() + "=" + node.getNodeValue());
                            }
                            webLogicMBeanMaker.processElement((Node)object7);
                        }
                        try {
                            String string = System.getProperty("weblogic.SPUpgrade.FromInstaller");
                            if (string == null) {
                                WebLogicMBeanMaker.dumpUnsupportedWarnings(webLogicMBeanMaker.root);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        boolean bl2 = false;
                        object7 = webLogicMBeanMaker.constructors.elements();
                        while (object7.hasMoreElements()) {
                            int n;
                            object6 = (Node)object7.nextElement();
                            NodeList nodeList2 = object6.getChildNodes();
                            for (n = 0; !(n >= nodeList2.getLength() || (arrayList = nodeList2.item(n)).getNodeType() == 1 && arrayList.getNodeName().equals("MBeanOperationArg")); ++n) {
                            }
                            if (n != nodeList2.getLength()) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            object7 = stringArray2.createElement("MBeanConstructor");
                            object7.setAttribute("Description", "Generated default constructor");
                            webLogicMBeanMaker.root.appendChild((Node)object7);
                            webLogicMBeanMaker.constructors.insertElementAt(object7, 0);
                        }
                        webLogicMBeanMaker.mBeanName = WebLogicMBeanMaker.getMBeanName(webLogicMBeanMaker.root);
                        if (!webLogicMBeanMaker.internalWLSBuild) {
                            object7 = null;
                            object7 = new DiabloIntfCodeGenerator(webLogicMBeanMaker);
                            object7.setRootDirectoryName(webLogicMBeanMaker.fileDir);
                            object7.generate((Object[])new String[]{webLogicMBeanMaker.mBeanName});
                        }
                        boolean bl3 = false;
                        object6 = System.getProperty("weblogic.FromSPUpgrade", "false");
                        if (((String)object6).equals("false")) {
                            if (webLogicMBeanMaker.createStubs) {
                                File file2;
                                bl3 = true;
                                if (webLogicMBeanMaker.preserveStubs && (file2 = new File(webLogicMBeanMaker.fileDir + File.separatorChar + webLogicMBeanMaker.mBeanName + "Impl.java")).exists()) {
                                    bl3 = false;
                                }
                            }
                        } else {
                            String string = webLogicMBeanMaker.mBeanName + "Impl.java";
                            String string2 = webLogicMBeanMaker.mBeanName + "Impl.class";
                            arrayList = new ArrayList();
                            String string3 = null;
                            boolean bl4 = WebLogicMBeanMaker.doesThisFileExist(arrayList, webLogicMBeanMaker.fileDir, string3, string);
                            if (!bl4) {
                                bl4 = WebLogicMBeanMaker.doesThisFileExist(arrayList, webLogicMBeanMaker.fileDir, string3, string2);
                            }
                            if (webLogicMBeanMaker.createStubs) {
                                bl3 = true;
                                if (bl4) {
                                    System.out.println("Warning: Customizer/stub already exists, but will be replaced because you specified -createStubs.");
                                }
                            } else if (!bl4) {
                                bl3 = true;
                            }
                        }
                        if (!bl3) continue;
                        ImplCodeGenerator implCodeGenerator = new ImplCodeGenerator(webLogicMBeanMaker);
                        implCodeGenerator.setRootDirectoryName(webLogicMBeanMaker.fileDir);
                        try {
                            implCodeGenerator.generate(new String[]{webLogicMBeanMaker.mBeanName});
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    System.out.println("MDF was provided, but there was no data.");
                    System.exit(1);
                }
            }
            if (webLogicMBeanMaker.mjf != null) {
                System.out.println("Creating an MJF from the contents of directory " + webLogicMBeanMaker.fileDir + "...");
                if (!webLogicMBeanMaker.noCompile) {
                    System.out.println("Compiling the files...");
                    webLogicMBeanMaker.compile(true);
                }
                File file3 = new File(webLogicMBeanMaker.fileDir);
                if (webLogicMBeanMaker.targetNameSpace == null) {
                    webLogicMBeanMaker.targetNameSpace = EXTENSIONS_XML_NAMESPACE;
                }
                file = JavaExec.createCommand((String)("weblogic.management.commo.BeanGenDriver " + webLogicMBeanMaker.fileDir + " " + webLogicMBeanMaker.mjf + " " + webLogicMBeanMaker.targetNameSpace + " " + webLogicMBeanMaker.schemaLocation));
                file.addDefaultClassPath();
                object4 = System.getProperty("weblogic.SPUpgrade.FromInstaller");
                file.addClassPath(new File(webLogicMBeanMaker.fileDir + "ClassesDir"));
                if (object4 != null) {
                    file.addClassPath(new File(System.getProperty("weblogic.SPUpgrade.WLSJarPath")));
                    file.addClassPath(new File(System.getProperty("weblogic.SPUpgrade.ToolsJarPath")));
                    file.addClassPath(new File(System.getProperty("weblogic.SPUpgrade.XbeanJarPath")));
                    file.addClassPath(new File(System.getProperty("weblogic.SPUpgrade.AntJarPath")));
                    file.addSystemProp("weblogic.SPUpgrade.FromInstaller", "true");
                    file.addSystemProp("weblogic.SPUpgrade.MBeanJarPath", System.getProperty("weblogic.SPUpgrade.MBeanJarPath"));
                    file.addSystemProp("weblogic.SPUpgrade.BindingJarPath", System.getProperty("weblogic.SPUpgrade.BindingJarPath"));
                    file.addSystemProp("weblogic.SPUpgrade.MBeanImplJarPath", System.getProperty("weblogic.SPUpgrade.MBeanImplJarPath"));
                    file.addSystemProp("weblogic.SPUpgrade.AntJarPath", System.getProperty("weblogic.SPUpgrade.AntJarPath"));
                    file.addSystemProp("weblogic.SPUpgrade.XbeanJarPath", System.getProperty("weblogic.SPUpgrade.XbeanJarPath"));
                    file.addSystemProp("weblogic.SPUpgrade.WLSJarPath", System.getProperty("weblogic.SPUpgrade.WLSJarPath"));
                    file.addSystemProp("weblogic.SPUpgrade.ToolsJarPath", System.getProperty("weblogic.SPUpgrade.ToolsJarPath"));
                }
                if (webLogicMBeanMaker.mbeantypesDir != null) {
                    file.addSystemProp("mbeantypesDir", webLogicMBeanMaker.mbeantypesDir);
                }
                if (webLogicMBeanMaker.jvmArgs != null) {
                    file.addJvmArgs(webLogicMBeanMaker.jvmArgs);
                }
                if ((object3 = System.getProperty(QNAME_COMPATIBILITY_PROP)) != null) {
                    file.addSystemProp(QNAME_COMPATIBILITY_PROP, (String)object3);
                }
                object2 = file.getProcess();
                CommoProcess.startIOThreads((Process)object2, "WLMaker-SubProcess: ", true);
                if (((Process)object2).waitFor() != 0) {
                    System.out.println("BeanGen code generation failed");
                    System.exit(1);
                }
                if (!webLogicMBeanMaker.mjf.endsWith("wlManagement.jar")) {
                    WebLogicMBeanMaker.generateSchema(webLogicMBeanMaker.fileDir, webLogicMBeanMaker.mjf, webLogicMBeanMaker.mbeantypesDir, webLogicMBeanMaker.jvmArgs);
                }
                webLogicMBeanMaker.compile(true);
                FileUtils.copy((File)new File(webLogicMBeanMaker.fileDir + "ClassesDir"), (File)file3);
                FileUtils.remove((File)new File(webLogicMBeanMaker.fileDir + "ClassesDir"));
                System.out.println("Creating the MJF...");
                stringArray2 = null;
                stringArray2 = webLogicMBeanMaker.includeSource ? new String[]{} : new String[]{"java"};
                object = JarFileObject.makeJar(webLogicMBeanMaker.mjf, file3, stringArray2);
                ((JarFileObject)object).save();
                System.out.println("MJF is created.");
            }
            if (webLogicMBeanMaker.fileLoc == null) {
                System.out.println("Deleting generated files in " + webLogicMBeanMaker.fileDir + "...");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (SecurityException securityException) {
            System.out.println("Security breach!. Request Terminated.");
        }
    }

    private static boolean doesThisFileExist(List list, String string, String string2, String string3) {
        String string4 = null;
        string4 = string2 == null ? string : string + File.separator + string2;
        File file = new File(string4);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = null;
            string5 = string2 != null ? string2 + File.separator + stringArray[i] : stringArray[i];
            File file2 = new File(string + File.separator + string5);
            if (file2.isDirectory()) {
                WebLogicMBeanMaker.doesThisFileExist(list, string, string5, string3);
                continue;
            }
            if (!file2.getName().equals(string3)) continue;
            return true;
        }
        return false;
    }

    private static void generateSchema(String string, String string2, String string3, String string4) throws IOException, InterruptedException {
        String string5;
        String string6 = string3 == null ? "" : " " + string3;
        JavaExec javaExec = JavaExec.createCommand((String)("weblogic.management.commo.JavaToSchemaUtil " + string + " " + string2 + string3));
        javaExec.addDefaultClassPath();
        String string7 = System.getProperty("weblogic.SPUpgrade.FromInstaller");
        if (string7 != null) {
            javaExec.addClassPath(new File(System.getProperty("weblogic.SPUpgrade.WLSJarPath")));
            javaExec.addClassPath(new File(System.getProperty("weblogic.SPUpgrade.ToolsJarPath")));
            javaExec.addClassPath(new File(System.getProperty("weblogic.SPUpgrade.XbeanJarPath")));
            javaExec.addClassPath(new File(System.getProperty("weblogic.SPUpgrade.AntJarPath")));
            javaExec.addSystemProp("weblogic.SPUpgrade.FromInstaller", "true");
            javaExec.addSystemProp("weblogic.SPUpgrade.MBeanJarPath", System.getProperty("weblogic.SPUpgrade.MBeanJarPath"));
            javaExec.addSystemProp("weblogic.SPUpgrade.MBeanImplJarPath", System.getProperty("weblogic.SPUpgrade.MBeanImplJarPath"));
            javaExec.addSystemProp("weblogic.SPUpgrade.BindingJarPath", System.getProperty("weblogic.SPUpgrade.BindingJarPath"));
            javaExec.addSystemProp("weblogic.SPUpgrade.AntJarPath", System.getProperty("weblogic.SPUpgrade.AntJarPath"));
            javaExec.addSystemProp("weblogic.SPUpgrade.XbeanJarPath", System.getProperty("weblogic.SPUpgrade.XbeanJarPath"));
            javaExec.addSystemProp("weblogic.SPUpgrade.WLSJarPath", System.getProperty("weblogic.SPUpgrade.WLSJarPath"));
            javaExec.addSystemProp("weblogic.SPUpgrade.ToolsJarPath", System.getProperty("weblogic.SPUpgrade.ToolsJarPath"));
        }
        if (string3 != null) {
            System.out.println("Adding mbeantypesDir=" + string3);
            javaExec.addSystemProp("mbeantypesDir", string3);
        }
        if (string4 != null) {
            javaExec.addJvmArgs(string4);
        }
        if ((string5 = System.getProperty(QNAME_COMPATIBILITY_PROP)) != null) {
            javaExec.addSystemProp(QNAME_COMPATIBILITY_PROP, string5);
        }
        Process process = javaExec.getProcess();
        CommoProcess.startIOThreads(process, "WLMaker-SchemaGen-SubProcess", true);
        if (process.waitFor() != 0) {
            System.out.println("Schema generation failed");
            System.exit(1);
        }
    }

    static void deleteFiles(File file) {
        String[] stringArray = file.list();
        String string = file.getAbsolutePath();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + File.separatorChar + stringArray[i];
            File file2 = new File(string2);
            if (file2.isDirectory()) {
                WebLogicMBeanMaker.deleteFiles(file2);
            }
            System.out.println("Deleting " + file2);
            file2.delete();
        }
        file.delete();
    }

    public static boolean checkCompilerClass() {
        try {
            Class.forName(JAVAC_COMPILER_CLASS);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    void compile(boolean bl) {
        Getopt2 getopt2 = new Getopt2();
        CompilerInvoker compilerInvoker = new CompilerInvoker(getopt2);
        File file = new File(this.fileDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            if (this.verbose) {
                getopt2.setFlag("commentary", true);
            }
            getopt2.setOption("compiler", this.compiler);
            if (this.source != null) {
                getopt2.setOption("source", this.source);
            }
            if (this.target != null) {
                getopt2.setOption("target", this.target);
            }
            if ("javac".equals(this.compiler) && WebLogicMBeanMaker.checkCompilerClass()) {
                getopt2.setOption("compilerclass", JAVAC_COMPILER_CLASS);
                getopt2.setFlag("noexit", true);
            }
            if (this.classpath != null) {
                getopt2.setOption("classpath", this.classpath);
            }
            if (this.fileLoc != null) {
                getopt2.setFlag("keepgenerated", true);
            } else if (this.includeSource) {
                getopt2.setFlag("keepgenerated", true);
            }
            getopt2.setOption("d", this.fileDir);
            getopt2.setFlag("g", this.compileDebug);
            Vector vector = new Vector();
            System.out.println("Creating the list.");
            this.accumulateFiles(file, vector, bl);
            System.out.println("Doing the compile.");
            String string = file.getAbsolutePath() + "ClassesDir";
            File file2 = new File(string);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            compilerInvoker.overrideTargetDirectory(string);
            this.compile(vector, compilerInvoker);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void accumulateFiles(File file, List list, boolean bl) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (bl && fileArray[i].isDirectory()) {
                this.accumulateFiles(fileArray[i], list, true);
                continue;
            }
            if (!fileArray[i].getName().endsWith(".java")) continue;
            boolean bl2 = false;
            if (this.internalWLSBuild) {
                if (fileArray[i].getName().endsWith("MBI.java")) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (!bl2) continue;
            list.add(fileArray[i].getAbsolutePath());
        }
    }

    private void compile(List list, CompilerInvoker compilerInvoker) {
        if (this.verbose) {
            System.out.print("Compiling these files");
            if (this.compileDebug) {
                System.out.print(" (debug)");
            }
            System.out.print("");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                System.out.println("   " + (String)iterator.next());
            }
        }
        try {
            if (!list.isEmpty()) {
                compilerInvoker.compile(list);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    String getMBeanPackageName() {
        return this.attrVal(this.root, "Package");
    }

    void makeExistingElementLists() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.getMBeanPackageName() + "." + this.mBeanName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Could not locate existing MBean class. Files will be overwritten");
            return;
        }
        try {
            Method method = clazz.getMethod("makeMBeanInfo", new Class[0]);
            ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void processElement(Node node) {
        String string = node.getNodeName();
        if (string.equals("MBeanAttribute")) {
            this.processAttribute(node);
        } else if (string.equals("MBeanNotification")) {
            this.processNotification(node);
        } else if (string.equals("MBeanOperation")) {
            this.processOperation(node);
        } else if (string.equals("MBeanConstructor")) {
            this.processConstructor(node);
        } else if (string.equals("MBeanImport")) {
            this.processImport(node);
        } else if (string.equals("MBeanImplements")) {
            this.processImplements(node);
        }
    }

    String getData(Node node) {
        return node.getFirstChild().getNodeValue();
    }

    static String getMBeanName(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("Name");
        return node2.getNodeValue();
    }

    String attrVal(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    boolean attrValBool(Node node, String string) {
        String string2 = this.attrVal(node, string);
        boolean bl = false;
        try {
            bl = Boolean.valueOf(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    String getDescription(Node node) throws Exception {
        String string = this.getDescriptionFromDocXML(node);
        String string2 = this.attrVal(node, "Description");
        if (this.doCheckDescription) {
            this.checkDescription(node, string2, string);
        }
        if (string == null || string.length() == 0) {
            return "No description provided.";
        }
        return string;
    }

    void checkDescription(Node node, String string, String string2) {
        String string3;
        if (!this.isDefined(string2) && this.isDefined(string) && (string3 = node.getNodeName()) != null && string3.startsWith("MBean")) {
            String string4 = this.getNameAttribute(node);
            String string5 = this.getMBeanTypeName(node.getOwnerDocument());
            String string6 = node.getNodeName();
            String string7 = this.mBeanName + ".xml";
            String string8 = this.mBeanName + DOC_XML_EXT;
            String string9 = "No description in " + string8 + " for " + string6 + " " + string4 + " in " + string7;
            System.out.println(string9);
        }
    }

    private Node getMBeanType(Document document) {
        if (document == null) {
            return null;
        }
        NodeList nodeList = document.getElementsByTagName("MBeanType");
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        return nodeList.item(0);
    }

    private String getMBeanTypeName(Document document) {
        return this.getNameAttribute(this.getMBeanType(document));
    }

    private String getNameAttribute(Node node) {
        Node node2;
        NamedNodeMap namedNodeMap;
        String string = "unknown";
        if (node != null && (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem("Name")) != null) {
            string = node2.getNodeValue();
        }
        return string;
    }

    private boolean isDefined(String string) {
        return string != null && string.length() != 0;
    }

    String getDescriptionFromDocXML(Node node) throws Exception {
        String string = this.mBeanName + DOC_XML_EXT;
        File file = new File(this.mdfPath + File.separator + string);
        if (!file.exists()) {
            return null;
        }
        this.getStringFromXMLDoc(file);
        return this.getDescriptionFromDoc(node);
    }

    String getDescriptionFromDoc(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("Name");
        if (node2 != null) {
            String string = node2.getNodeValue();
            String string2 = (String)this.attributeDescriptionMap.get(string);
            if (string2 == null) {
                return null;
            }
            String[] stringArray = StringUtils.splitCompletely((String)string2, (String)"\n");
            String string3 = StringUtils.join((String[])stringArray, (String)" ");
            return string3;
        }
        return null;
    }

    void getStringFromXMLDoc(File file) throws Exception {
        if (this.isDocFileLoaded) {
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.processForDescription(node);
        }
        this.isDocFileLoaded = true;
    }

    void processForDescription(Node node) {
        if (node.getNodeName().equals("MBeanType")) {
            this.handlemBeanType(node);
            this.processMBeanAttribute(node);
        }
    }

    void handlemBeanType(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object = nodeList.item(i);
            if (object.getNodeName().equals("MBeanAttribute")) {
                this.processMBeanAttribute((Node)object);
                continue;
            }
            if (!object.getNodeName().equals("MBeanOperation")) continue;
            this.processMBeanOperation((Node)object);
        }
        for (Object object : this.attributeDescriptionMap.keySet()) {
            String string = (String)this.attributeDescriptionMap.get(object);
        }
    }

    void processMBeanOperation(Node node) {
        this.processMBeanAttribute(node);
    }

    void processMBeanAttribute(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = "";
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (!node2.getNodeName().equals("Name")) continue;
                string = node2.getNodeValue();
            }
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!node3.getNodeName().equals("Description")) continue;
            this.handleDescriptionChildren(node3, string);
        }
    }

    void handleDescriptionChildren(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("Lead")) {
                this.handleDescriptionText(node2, string);
                continue;
            }
            if (!node2.getNodeName().equals("Detail")) continue;
            this.handleDescriptionText(node2, string);
        }
    }

    void handleDescriptionText(Node node, String string) {
        String string2 = "";
        if (this.attributeDescriptionMap.containsKey(string)) {
            string2 = (String)this.attributeDescriptionMap.get(string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        String string3 = byteArrayOutputStream.toString();
        Matcher matcher = pattern.matcher(string3);
        if (!matcher.lookingAt()) {
            throw new RuntimeException("Input pattern does not match " + matcher.pattern().toString() + " : " + string3);
        }
        String string4 = matcher.group(2).trim();
        this.attributeDescriptionMap.put(string, string2 + string4);
    }

    boolean isArray(Node node) {
        String string = this.attrVal(node, "Type");
        if (string != null) {
            return string.trim().endsWith("]");
        }
        return false;
    }

    void printName(Node node) {
        String string = node.getNodeName();
        String string2 = null;
        if (string.equals("MBeanConstructor")) {
            string2 = this.mBeanName;
        } else {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("Name");
            string2 = node2.getNodeValue();
        }
        System.out.print(string2 + "\n");
    }

    void printNotificationTypes(Node node) {
        System.out.print(this.attrVal(node, "NotificationTypes") + "\n");
    }

    void printData(Node node) {
        System.out.print(this.getData(node) + "\n");
    }

    Vector getParameterTypes(Node node) {
        Vector<String> vector = new Vector<String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals("MBeanOperationArg")) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            vector.addElement(namedNodeMap.getNamedItem("Type").getNodeValue());
        }
        return vector;
    }

    void printSigniture(Node node) {
        Node node2;
        int n;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = node.getNodeName();
        String string2 = null;
        string2 = !string.equals("MBeanConstructor") ? namedNodeMap.getNamedItem("Name").getNodeValue() : this.mBeanName;
        System.out.print(string2 + " ( ");
        NodeList nodeList = node.getChildNodes();
        boolean bl = true;
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals("MBeanOperationArg")) continue;
            if (!bl) {
                System.out.print(", ");
            }
            bl = false;
            NamedNodeMap namedNodeMap2 = node2.getAttributes();
            System.out.print(namedNodeMap2.getNamedItem("Type").getNodeValue() + " " + namedNodeMap2.getNamedItem("Name").getNodeValue());
        }
        System.out.print(" )");
        bl = true;
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals("MBeanException")) continue;
            if (bl) {
                System.out.print(" throws ");
            } else {
                System.out.print(", ");
            }
            bl = false;
            System.out.print(node2.getFirstChild().getNodeValue());
        }
        System.out.print("\n");
    }

    void printTags(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeName().equals("Name")) continue;
            System.out.println("     " + node2.getNodeName() + "=" + node2.getNodeValue());
        }
    }

    void processOperation(Node node) {
        if (this.verbose) {
            System.out.print("   Operation: ");
        }
        if (this.verbose) {
            this.printSigniture(node);
        }
        if (this.verbose) {
            this.printTags(node);
        }
        this.operations.addElement(node);
    }

    void processConstructor(Node node) {
        if (this.verbose) {
            System.out.print("   Constructor: ");
        }
        if (this.verbose) {
            this.printSigniture(node);
        }
        if (this.verbose) {
            this.printTags(node);
        }
        this.constructors.addElement(node);
    }

    void processImport(Node node) {
        if (this.verbose) {
            System.out.print("   Import: ");
        }
        if (this.verbose) {
            this.printData(node);
        }
        if (this.verbose) {
            this.printTags(node);
        }
        this.imports.addElement(node);
    }

    void processImplements(Node node) {
        if (this.verbose) {
            System.out.print("   Implements: ");
        }
        if (this.verbose) {
            this.printData(node);
        }
        if (this.verbose) {
            this.printTags(node);
        }
        this.implementsSet.addElement(node);
    }

    void processAttribute(Node node) {
        if (this.verbose) {
            System.out.print("   Attribute: ");
        }
        if (this.verbose) {
            this.printName(node);
        }
        if (this.verbose) {
            this.printTags(node);
        }
        this.attributes.addElement(node);
    }

    void processNotification(Node node) {
        if (this.verbose) {
            System.out.print("   Notification: ");
        }
        if (this.verbose) {
            this.printNotificationTypes(node);
        }
        if (this.verbose) {
            this.printTags(node);
        }
        this.notifications.addElement(node);
    }

    public String mBeanName() {
        if (this.mBeanName == null) {
            this.mBeanName = this.getName(this.root);
        }
        return this.mBeanName;
    }

    String getName(Node node) {
        String string = node.getNodeName();
        if (string.equals("MBeanConstructor")) {
            return this.mBeanName;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("Name");
        return node2.getNodeValue();
    }

    static {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        mbeanTypeAttributesNotSupportedIn90 = new ArrayList();
        mbeanAttributesNotSupportedIn90 = new ArrayList();
        mbeanOperationsNotSupportedIn90 = new ArrayList();
        mbeanOperationsArgNotSupportedIn90 = new ArrayList();
        opts = null;
    }

    public class MyErrorHandler
    implements ErrorHandler {
        public void fatalError(SAXParseException sAXParseException) {
            System.out.println("******************************************************");
            System.out.println("fatalError:");
            sAXParseException.printStackTrace();
            System.out.println("******************************************************");
        }

        public void error(SAXParseException sAXParseException) {
            System.out.println("******************************************************");
            System.out.println("error:");
            sAXParseException.printStackTrace();
            System.out.println("******************************************************");
        }

        public void warning(SAXParseException sAXParseException) {
            System.out.println("******************************************************");
            System.out.println("warning:");
            sAXParseException.printStackTrace();
            System.out.println("******************************************************");
        }

        MyErrorHandler() {
        }
    }
}

