/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.common.internal.PeerInfoable;
import weblogic.common.internal.VersioningError;
import weblogic.utils.StringUtils;

public class PackageInfo
implements Serializable {
    static final long serialVersionUID = -1803933647595757879L;
    protected String implVendor;
    protected String implTitle;
    protected String implVersion;
    protected int major;
    protected int minor;
    protected int servicePack;
    protected int rollingPatch;
    protected boolean temporaryPatch;

    protected PackageInfo() {
    }

    protected PackageInfo(int n, int n2, int n3, int n4, boolean bl) {
        this.major = n;
        this.minor = n2;
        this.servicePack = n3;
        this.rollingPatch = n4;
        this.temporaryPatch = bl;
    }

    PackageInfo(String string, String string2, String string3) {
        this.implVendor = string;
        this.implTitle = string2;
        this.implVersion = string3;
        try {
            String[] stringArray = StringUtils.splitCompletely(string3, " .");
            if (stringArray.length < 2) {
                throw new VersioningError("Malformed version number in MANIFEST: " + string3 + " for vendor:" + string + " and title:" + string2);
            }
            this.major = Integer.parseInt(stringArray[0]);
            this.minor = Integer.parseInt(stringArray[1]);
            if (stringArray.length > 2) {
                this.servicePack = Integer.parseInt(stringArray[2]);
            }
            if (stringArray.length > 3) {
                this.rollingPatch = Integer.parseInt(stringArray[3]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersioningError("Malformed version in MANIFEST: " + string3 + " for vendor:" + string + " and title:" + string2);
        }
    }

    public final String getImplementationVendor() {
        return this.implVendor;
    }

    public final String getImplementationTitle() {
        return this.implTitle;
    }

    public final String getImplementationVersion() {
        return this.implVersion;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getServicePack() {
        return this.servicePack;
    }

    public final int getRollingPatch() {
        return this.rollingPatch;
    }

    public final boolean hasTemporaryPatch() {
        return this.temporaryPatch;
    }

    public final boolean laterThan(PackageInfo packageInfo) {
        if (this.major != packageInfo.major) {
            return this.major > packageInfo.major;
        }
        if (this.minor != packageInfo.minor) {
            return this.minor > packageInfo.minor;
        }
        if (this.servicePack != packageInfo.servicePack) {
            return this.servicePack > packageInfo.servicePack;
        }
        if (this.rollingPatch != packageInfo.rollingPatch) {
            return this.rollingPatch > packageInfo.rollingPatch;
        }
        if (this.temporaryPatch == packageInfo.temporaryPatch) {
            return false;
        }
        return this.temporaryPatch;
    }

    public final boolean earlierThan(PackageInfo packageInfo) {
        if (this.major != packageInfo.major) {
            return this.major < packageInfo.major;
        }
        if (this.minor != packageInfo.minor) {
            return this.minor < packageInfo.minor;
        }
        if (this.servicePack != packageInfo.servicePack) {
            return this.servicePack < packageInfo.servicePack;
        }
        if (this.rollingPatch != packageInfo.rollingPatch) {
            return this.rollingPatch < packageInfo.rollingPatch;
        }
        if (this.temporaryPatch == packageInfo.temporaryPatch) {
            return false;
        }
        return this.temporaryPatch;
    }

    public final boolean laterThan(PackageInfo[] packageInfoArray) {
        for (int i = 0; i < packageInfoArray.length; ++i) {
            if (!this.laterThan(packageInfoArray[i])) continue;
            return true;
        }
        return this.major > packageInfoArray[packageInfoArray.length - 1].getMajor();
    }

    public static boolean laterThan(ObjectOutput objectOutput, PackageInfo[] packageInfoArray) {
        return ((PeerInfoable)((Object)objectOutput)).getPeerInfo().laterThan(packageInfoArray);
    }

    public String toString() {
        return "(" + this.implVendor + ", " + this.implTitle + ", " + this.major + "." + this.minor + "." + this.servicePack + "." + this.rollingPatch + ")";
    }
}

