/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersioningError;
import weblogic.utils.jars.ManifestManager;

public class VersionInfo
extends PackageInfo
implements Serializable {
    private static final long serialVersionUID = -7556401008896489922L;
    private static final String BEA_VENDOR_STRING = "BEA Systems";
    private static final String[] SUPPORTED_PREFIXES = new String[]{"WebLogic", "AquaLogic", "Kodo"};
    private static String defaultImplVendor = "BEA Systems";
    private static String defaultImplTitle = "Unknown";
    private static String defaultImplVersion = "Unknown";
    private static String defaultVersionString = "Unknown";
    private static int defaultMajor = 1;
    private static int defaultMinor = 0;
    private static int defaultSP = 0;
    private static int defaultPatch = 0;
    private static String DEFAULT_PROTOCOL_PRODUCT_ID = "WebLogic Server";
    private static boolean searchClasspath = false;
    private final PackageInfo[] packages;
    private String releaseVersion;
    private byte[] versionInfoAsBytes = null;

    protected VersionInfo() {
        this.packages = null;
    }

    public VersionInfo(boolean bl) throws VersioningError {
        this.packages = VersionInfo.getPackageInfos(SUPPORTED_PREFIXES);
        if (this.packages.length == 0) {
            throw new VersioningError("No WebLogic packages defined in CLASSPATH");
        }
        this.implVendor = this.packages[0].getImplementationVendor();
        this.implTitle = this.packages[0].getImplementationTitle();
        this.implVersion = this.packages[0].getImplementationVersion();
        this.major = this.packages[0].getMajor();
        this.minor = this.packages[0].getMinor();
        this.servicePack = this.packages[0].getServicePack();
        this.rollingPatch = this.packages[0].getRollingPatch();
        this.releaseVersion = this.major + "." + this.minor + "." + this.servicePack + "." + this.rollingPatch;
    }

    public VersionInfo(int n, int n2, int n3, int n4) throws VersioningError {
        super(n, n2, n3, n4, false);
        this.implVendor = defaultImplVendor;
        this.implTitle = defaultImplTitle;
        this.implVersion = defaultImplVersion;
        this.major = n;
        this.minor = n2;
        this.servicePack = n3;
        this.rollingPatch = n4;
        this.packages = this.initializePackages(defaultImplVersion);
        this.releaseVersion = defaultVersionString;
    }

    public VersionInfo(int n, int n2, int n3, int n4, boolean bl) {
        this(n, n2, n3, n4, bl, null);
    }

    public VersionInfo(int n, int n2, int n3, int n4, boolean bl, PackageInfo[] packageInfoArray) {
        super(n, n2, n3, n4, bl);
        this.packages = packageInfoArray;
    }

    public static synchronized VersionInfo theOne() {
        return SINGLETON.defaultVersionInfo;
    }

    public VersionInfo(String string) {
        super(defaultImplVendor, defaultImplTitle, string);
        this.packages = this.initializePackages(string);
    }

    public static synchronized void initialize(boolean bl, String string, String string2, String string3, String string4, int n, int n2, int n3, int n4) {
        searchClasspath = bl;
        defaultImplVendor = string;
        defaultImplTitle = string2;
        defaultImplVersion = string3;
        defaultVersionString = string4;
        defaultMajor = n;
        defaultMinor = n2;
        defaultSP = n3;
        defaultPatch = n4;
    }

    private PackageInfo[] initializePackages(String string) {
        return new PackageInfo[]{new PackageInfo(defaultImplVendor, defaultImplTitle, string)};
    }

    public final boolean compatible(String string) {
        try {
            VersionInfo versionInfo = new VersionInfo(string);
            int n = versionInfo.getMajor();
            return n >= 7;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final String rejectionReason(String string) {
        try {
            VersionInfo versionInfo = new VersionInfo(string);
            int n = versionInfo.getMajor();
            if (n < 7) {
                return "Incompatible versions - this server: '" + VersionInfo.theOne().getReleaseVersion() + "' client: '" + string + "'. client version should be greater than or equal to 7.0 to support " + "interop";
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final PackageInfo[] getPackages() {
        return this.packages;
    }

    public final String getReleaseVersion() {
        return this.releaseVersion;
    }

    public static final PackageInfo[] getPackageInfos(String[] stringArray) {
        PackageInfo[] packageInfoArray;
        boolean bl;
        ArrayList<PackageInfo> arrayList = new ArrayList<PackageInfo>();
        PackageInfo packageInfo = null;
        boolean bl2 = bl = stringArray != null && (stringArray.length == 0 || stringArray.length == 1 && stringArray[0].equals("*"));
        if (stringArray == null) {
            stringArray = SUPPORTED_PREFIXES;
        }
        Object[] objectArray = ManifestManager.getManifests();
        while (objectArray.hasNext()) {
            Manifest manifest = (Manifest)objectArray.next();
            Attributes attributes = manifest.getMainAttributes();
            packageInfoArray = (PackageInfo[])attributes.get(Attributes.Name.IMPLEMENTATION_VENDOR);
            if (packageInfoArray == null || !packageInfoArray.equals(BEA_VENDOR_STRING)) continue;
            String string = (String)attributes.get(Attributes.Name.IMPLEMENTATION_TITLE);
            String[] stringArray2 = string.split("\\s");
            String string2 = stringArray2[0];
            string2.trim();
            if (packageInfo == null && string.startsWith(DEFAULT_PROTOCOL_PRODUCT_ID)) {
                packageInfo = new PackageInfo((String)attributes.get(Attributes.Name.IMPLEMENTATION_VENDOR), (String)attributes.get(Attributes.Name.IMPLEMENTATION_TITLE), (String)attributes.get(Attributes.Name.IMPLEMENTATION_VERSION));
                continue;
            }
            if (bl) {
                arrayList.add(new PackageInfo((String)attributes.get(Attributes.Name.IMPLEMENTATION_VENDOR), (String)attributes.get(Attributes.Name.IMPLEMENTATION_TITLE), (String)attributes.get(Attributes.Name.IMPLEMENTATION_VERSION)));
                continue;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                arrayList.add(new PackageInfo((String)attributes.get(Attributes.Name.IMPLEMENTATION_VENDOR), (String)attributes.get(Attributes.Name.IMPLEMENTATION_TITLE), (String)attributes.get(Attributes.Name.IMPLEMENTATION_VERSION)));
            }
        }
        objectArray = arrayList.toArray();
        int n = objectArray.length;
        int n2 = 0;
        if (packageInfo != null) {
            ++n;
            n2 = 1;
        }
        packageInfoArray = new PackageInfo[n];
        if (packageInfo != null) {
            packageInfoArray[0] = packageInfo;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            packageInfoArray[n2++] = (PackageInfo)objectArray[i];
        }
        return packageInfoArray;
    }

    public final byte[] getVersionInfoForNetworkClassLoader() {
        if (this.versionInfoAsBytes == null) {
            String string = Attributes.Name.IMPLEMENTATION_VENDOR + ": " + this.packages[0].getImplementationVendor();
            String string2 = Attributes.Name.IMPLEMENTATION_TITLE + ": " + this.packages[0].getImplementationTitle();
            String string3 = Attributes.Name.IMPLEMENTATION_VERSION + ": " + this.packages[0].getImplementationVersion();
            this.versionInfoAsBytes = (string + "\n" + string2 + "\n" + string3 + "\n").getBytes();
        }
        return this.versionInfoAsBytes;
    }

    static /* synthetic */ boolean access$000() {
        return searchClasspath;
    }

    static /* synthetic */ int access$100() {
        return defaultMajor;
    }

    static /* synthetic */ int access$200() {
        return defaultMinor;
    }

    static /* synthetic */ int access$300() {
        return defaultSP;
    }

    static /* synthetic */ int access$400() {
        return defaultPatch;
    }

    private static class SINGLETON {
        static VersionInfo defaultVersionInfo = VersionInfo.access$000() ? new VersionInfo(true) : new VersionInfo(VersionInfo.access$100(), VersionInfo.access$200(), VersionInfo.access$300(), VersionInfo.access$400());

        private SINGLETON() {
        }
    }
}

