/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import weblogic.utils.ArrayUtils;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;
import weblogic.utils.io.StreamUtils;

public final class FileUtils {
    private static final int SUFFIX_LENGTH = 4;
    private static final int MAX_FILENAME_LENGTH = 100;
    public static final FileFilter STAR = new FileFilter(){

        public boolean accept(File file) {
            return true;
        }
    };
    public static final FileFilter DIR = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static int counter = -1;

    private FileUtils() {
    }

    public static FileFilter makeExtensionFilter(final String string) {
        return new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().endsWith(string);
            }
        };
    }

    public static FileFilter makeExtensionFilter(final String[] stringArray) {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!file.getName().endsWith(stringArray[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static File[] splitPath(String string) {
        String[] stringArray = StringUtils.splitCompletely(string, File.pathSeparator);
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long computeCRC(File file) throws IOException {
        CRC32 cRC32 = new CRC32();
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new CheckedInputStream(new FileInputStream(file), cRC32);
            byte[] byArray = new byte[1024];
            int n = 0;
            while (n != -1) {
                n = filterInputStream.read(byArray);
            }
            long l = cRC32.getValue();
            return l;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream inputStream, File file) throws IOException {
        Object object;
        String string = file.getParent();
        if (string != null) {
            object = new File(string);
            ((File)object).mkdirs();
        }
        object = new FileOutputStream(file);
        try {
            StreamUtils.writeTo(inputStream, (OutputStream)object);
            ((OutputStream)object).flush();
        }
        finally {
            ((OutputStream)object).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(FileInputStream fileInputStream, File file) throws IOException {
        Object object;
        String string = file.getParent();
        if (string != null) {
            object = new File(string);
            ((File)object).mkdirs();
        }
        object = new FileOutputStream(file);
        try {
            FileChannel fileChannel = fileInputStream.getChannel();
            FileChannel fileChannel2 = ((FileOutputStream)object).getChannel();
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        finally {
            ((FileOutputStream)object).close();
        }
    }

    public static void copy(File file, File file2) throws IOException {
        FileUtils.copy(file, file2, true, null);
    }

    public static void copy(File file, File file2, Set set) throws IOException {
        FileUtils.copy(file, file2, true, set);
    }

    public static void copyPreserveTimestamps(File file, File file2) throws IOException {
        FileUtils.copy(file, file2, true, null, true);
    }

    public static void copyNoOverwrite(File file, File file2) throws IOException {
        FileUtils.copy(file, file2, false, null);
    }

    public static void copyNoOverwrite(File file, File file2, Set set) throws IOException {
        FileUtils.copy(file, file2, false, set);
    }

    private static void copy(File file, File file2, boolean bl, Set set) throws IOException {
        FileUtils.copy(file, file2, bl, set, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File file, File file2, boolean bl, Set set, boolean bl2) throws IOException {
        if (set != null && set.contains(file)) {
            return;
        }
        if (!file.isDirectory()) {
            InputStream inputStream = null;
            try {
                File file3 = file2;
                if (file2.isDirectory()) {
                    file3 = new File(file2, file.getName());
                }
                if (!bl && file3.exists()) {
                    return;
                }
                inputStream = new FileInputStream(file);
                FileUtils.writeToFile(inputStream, file3);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        } else {
            if (file2.exists()) {
                if (!file2.isDirectory()) {
                    throw new IOException("Target for directory copy is a file");
                }
            } else {
                file2.mkdirs();
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file4 = fileArray[i];
                File file5 = new File(file2, file4.getName());
                FileUtils.copy(file4, file5, bl, set, bl2);
            }
        }
        if (bl2) {
            file2.setLastModified(file.lastModified());
        }
    }

    public static boolean remove(File file, FileFilter fileFilter) {
        boolean bl = true;
        File[] fileArray = file.listFiles(fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            boolean bl2;
            File file2 = fileArray[i];
            boolean bl3 = bl2 = file2.isDirectory() ? FileUtils.remove(file2) : file2.delete();
            if (!bl || bl2) continue;
            bl = false;
        }
        return bl;
    }

    public static boolean remove(File file) {
        boolean bl = file.isDirectory() ? FileUtils.remove(file, STAR) : true;
        return file.delete() ? bl : false;
    }

    public static File[] find(File file, FileFilter fileFilter) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory.");
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                ArrayUtils.addAll(arrayList, FileUtils.find(file2, fileFilter));
            }
            if (!fileFilter.accept(file2)) continue;
            arrayList.add(file2);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static long getAbsoluteLastModified(File file) {
        long l = file.lastModified();
        if (!file.isDirectory()) {
            return l;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            long l2 = FileUtils.getAbsoluteLastModified(file2);
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public static File createTempDir(String string) throws IOException {
        return FileUtils.createTempDir(string, null);
    }

    public static File createTempDir(String string, File file) throws IOException {
        File file2;
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (file == null) {
            file2 = File.createTempFile("fileutils", null);
            file = file2.getParentFile();
            file2.delete();
        }
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        while (!(file2 = new File(file, string + ++counter)).mkdirs()) {
        }
        return file2;
    }

    public static FileLock getFileLock(FileChannel fileChannel, long l) throws IOException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        FileLock fileLock = null;
        while (fileLock == null && l2 <= l3) {
            fileLock = fileChannel.tryLock();
            if (fileLock != null) continue;
            long l4 = l3 - l2;
            try {
                Thread.sleep(l4 > 500L ? 500L : l4);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l2 = System.currentTimeMillis();
        }
        return fileLock;
    }

    public static String mapNameToFileName(String string) {
        String string2;
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        byte[] byArray2 = new byte[1024];
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 97 && byArray[i] <= 122 || byArray[i] >= 48 && byArray[i] <= 57 || byArray[i] == 45 || byArray[i] == 95 || byArray[i] == 43 || byArray[i] == 36) {
                byArray2[n++] = byArray[i];
                continue;
            }
            if (byArray[i] >= 65 && byArray[i] <= 90) {
                byArray2[n++] = byArray[i];
                bl = true;
                continue;
            }
            if (byArray[i] == 32) {
                byArray2[n++] = 95;
                bl = true;
                continue;
            }
            bl = true;
            string2 = Hex.asHex(byArray[i]);
            byte[] byArray3 = string2.getBytes();
            System.arraycopy(byArray3, 0, byArray2, n, byArray3.length);
            n += byArray3.length;
        }
        String string3 = new String(byArray2, 0, n);
        if (string3.length() > 100) {
            string3 = string3.substring(0, 99);
            bl = true;
        }
        if (bl) {
            string2 = "" + string.hashCode();
            if (string2.length() > 4) {
                string2 = string2.substring(string2.length() - 4);
            }
            return string3 + "-" + string2;
        }
        return string3;
    }

    public static boolean isAbsolute(File file) {
        if (file == null || file.getPath().length() == 0) {
            return false;
        }
        return file.isAbsolute() || file.getPath().startsWith("/") || file.getPath().startsWith("\\") || FileUtils.testDriveSpecifier(file);
    }

    public static long getLastModified(File file) {
        long l = file.lastModified();
        if (!file.isDirectory()) {
            return l;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return l;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            long l2 = FileUtils.getLastModified(fileArray[i]);
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    private static boolean testDriveSpecifier(File file) {
        String string = file.getPath();
        return string.length() > 2 && (string.charAt(1) == ':' && string.charAt(2) == '\\' || string.charAt(2) == '/');
    }

    public static String normalize(String string) {
        if (string == null) {
            return string;
        }
        if ("/".equals(File.separator)) {
            if (string.length() >= 2 && string.charAt(1) == ':') {
                string = string.substring(2);
            }
            return string.replace('\\', File.separatorChar);
        }
        return string.replace('/', File.separatorChar);
    }
}

