/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class StackTraceUtilsClient {
    public static String throwable2StackTrace(Throwable throwable) {
        if (throwable == null) {
            throwable = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        return byteArrayOutputStream.toString();
    }

    public static String throwable2StackTraceTruncated(Throwable throwable, int n) {
        if (throwable == null) {
            throwable = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        if (n == -1) {
            return StackTraceUtilsClient.throwable2StackTrace(throwable);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        StackTraceUtilsClient.printStackTrace(throwable, printStream, n);
        return byteArrayOutputStream.toString();
    }

    private static void printStackTrace(Throwable throwable, PrintStream printStream, int n) {
        Throwable throwable2;
        printStream.println(throwable);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n2 = n;
        if (n2 > stackTraceElementArray.length) {
            n2 = stackTraceElementArray.length;
        }
        for (int i = 0; i < n2; ++i) {
            printStream.println("\tat " + stackTraceElementArray[i]);
        }
        if (n2 < stackTraceElementArray.length) {
            printStream.println("\tTruncated. see log file for complete stacktrace");
        }
        if ((throwable2 = throwable.getCause()) != null) {
            StackTraceUtilsClient.printStackTrace(throwable2, printStream, n);
        }
    }

    public static Throwable getThrowableWithCause(Throwable throwable) {
        try {
            Class[] classArray = new Class[]{String.class};
            Constructor<?> constructor = throwable.getClass().getConstructor(classArray);
            Object[] objectArray = new Object[]{throwable.getMessage()};
            Throwable throwable2 = (Throwable)constructor.newInstance(objectArray);
            throwable2.setStackTrace(throwable.getStackTrace());
            StackTraceUtilsClient.setThrowableCause(throwable2, throwable.getCause());
            StackTraceUtilsClient.setThrowableCause(throwable, throwable2);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throwable.setStackTrace(StackTraceUtilsClient.trimStackTrace(new Throwable().getStackTrace(), 1));
        return throwable;
    }

    private static StackTraceElement[] trimStackTrace(StackTraceElement[] stackTraceElementArray, int n) {
        if (stackTraceElementArray.length - n <= 0) {
            return stackTraceElementArray;
        }
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - n];
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            stackTraceElementArray2[i] = stackTraceElementArray[i + n];
        }
        return stackTraceElementArray2;
    }

    private static void setThrowableCause(Throwable throwable, Throwable throwable2) throws IllegalAccessException {
        try {
            throwable.initCause(throwable2);
        }
        catch (IllegalStateException illegalStateException) {
            try {
                Field field = Throwable.class.getDeclaredField("cause");
                field.setAccessible(true);
                field.set(throwable, throwable2);
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            throw new IllegalAccessException("Error setting cause");
        }
    }
}

